#ifndef _LIBERIC_NET_H
#define _LIBERIC_NET_H

#include <openssl/bio.h>
#include <liberic_session.h>
#include <pp/cfg.h>

#define ERIC_NET_DEFAULT_HTTPS_PORT		443
#define ERIC_NET_DEFAULT_HTTP_PORT		80
#define ERIC_NET_DEFAULT_SSH_PORT		22
#define ERIC_NET_DEFAULT_TELNET_PORT		23
#define ERIC_NET_DEFAULT_TERMSRV_BASEPORT	4000

#ifdef PRODUCT_SMIDC
// need very long timeout for Supermicro when using ESB2 sideband NIC!
#define PP_NET_IO_TIMEOUT			600
#else
#define PP_NET_IO_TIMEOUT			60
#endif

typedef enum { WAIT, NOWAIT } eric_net_close_mode_t;

typedef enum {
    PP_NET_PROTOCOL_TYPE_HTTP,
    PP_NET_PROTOCOL_TYPE_HTTPS,
    PP_NET_PROTOCOL_TYPE_RFB,
    PP_NET_PROTOCOL_TYPE_MSP,
    PP_NET_PROTOCOL_TYPE_TELNET,
    PP_NET_PROTOCOL_TYPE_SSH,
    PP_NET_PROTOCOL_TYPE_TERMSRV,
    PP_NET_PROTOCOL_TYPE_ASMI_TPT,
    PP_NET_PROTOCOL_TYPE_NET_EVENT,
    PP_NET_PROTOCOL_TYPE_UNKNOWN,
} pp_net_protocol_type_t;

typedef struct {
    pp_net_protocol_type_t protocol_type;
    BIO * bio;
    u_int port_offset;
    char ssl;
} pp_net_conn_data_t;

typedef u_short (*get_port_func_t)(void);
typedef BIO * (*init_bio_func_t)(u_short port);
typedef void (*conn_handler_func_t)(pp_net_conn_data_t * conn_data);

int eric_net_init(void);
void eric_net_cleanup(void);
#ifdef PP_FEAT_ESB2_TPT
void eric_net_esb2_tpt_cleanup(void);
#endif
int eric_net_start_listener(void);
int eric_net_register_proto(pp_net_protocol_type_t type, const char * name, u_int port_count,
			    get_port_func_t get_port, init_bio_func_t init_bio, conn_handler_func_t handler);
void eric_net_unregister_proto(pp_net_protocol_type_t type);
u_int eric_net_get_registered_port_count(pp_net_protocol_type_t type);
BIO * eric_net_init_bio_standard(u_short port);
BIO * eric_net_init_bio_https(u_short port);
void eric_net_demuxer_handle_connection(pp_net_conn_data_t * conn_data);

void eric_net_reconf_listener(void);
int eric_net_listener_reconfiguring(void);

int eric_net_close(BIO * bio, eric_net_close_mode_t close_mode);
int eric_net_read_exact(BIO * bio, void * buf, size_t len,
			       int no_timeout);
int eric_net_write_exact(BIO * bio, const void * buf, size_t len,
				int no_timeout);
ssize_t eric_net_read(BIO * bio, void * buf, size_t len,
			     int no_timeout);
ssize_t eric_net_write(BIO * bio, const void * buf, size_t len,
			      int no_timeout);
BIO * eric_net_open_connection(const char * server, const char * port, unsigned int to_sec);
void eric_net_close_connection(BIO * bio);

eric_session_int_id_t eric_net_ssl_auth_check(BIO * bio, const char** error);
void eric_net_ssl_auth_logout(BIO *bio);

char** eric_net_wlan_get_essids(void);
int eric_net_wlan_get_signal_level(void);
char* eric_net_wlan_get_ap_mac(void);

#ifdef PP_FEAT_ESB2_TPT
/**
 * Returns the status of the TPT connection.
 *
 * @return status (one of the ESB2_TPT_STAT_XXXX values defined in esb2_tpt.h)
 *         -1: TPT not available
 *         -2: not initialized
 */
int eric_net_tpt_get_status(void);
#endif

#endif /* _LIBERIC_NET_H */
