#ifndef _NET_H
#define _NET_H

typedef struct {
    pp_net_protocol_type_t protocol_type;	// the protocol type
    const char * name;				// just a description
    BIO ** bios;				// place to store the BIOs (array)
    u_int bio_count;				// how many BIOs
    get_port_func_t get_port;			// returns port
    init_bio_func_t init_bio;			// initializes and returns BIO
    conn_handler_func_t handler;		// connection handler
} acceptor_t;

extern volatile int listener_should_die;

int init_ssl(void);
void uninit_ssl(void);

BIO* std_init_bio(u_short port);
BIO* https_init_bio(u_short port);

void * accept_thread_fkt(void * _bio);

#define NET_DEBUG 1

#if NET_DEBUG
# define _D(fmt, args...)	{ pp_log("NET DEBUG: " fmt, ##args); }
#else
# define _D(fmt, args...)	{ }
#endif

#endif /* _NET_H */
