#include <sys/time.h>
#include <pp/base.h>
#include <pp/cfg.h>
#include <liberic_notify.h>
#include "utils.h"

void
eric_notify_get_time_string(time_t t, char * buf, size_t buf_size)
{
    char * utc_offset_str;
    time_t _t;
    struct tm br_time;
    int offset = 0;
    
    pp_cfg_get(&utc_offset_str, "time.utc_offset");
    if (strchr(utc_offset_str, '/')) {
        offset = 0;
    } else if (strchr(utc_offset_str, '+')) {
        if (sscanf(utc_offset_str, "+ %d h", &offset) != 1) {
            offset = 0;
        }
    } else if (strchr(utc_offset_str, '-')) {
        if (sscanf(utc_offset_str, "- %d h", &offset) != 1) {
            offset = 0;
        } else {
            offset = offset * -1;
        }     
    }
    free(utc_offset_str);

    _t = t + offset * 3600;
    localtime_r(&_t, &br_time);
    strftime(buf, buf_size, "%m/%d/%Y %R:%S", &br_time);  
}
