/*-----------------------------------------------------------------------------
	header file for MC68360 terminal emulation
	Thomas Hoffmann, TUChZ Sektion Rechnertechnik und Datenkommunikation 
	aug 14, 1996
	modified by Marcus Georgi, Feb 2000
-----------------------------------------------------------------------------*/

#ifndef __TERMINAL_H__
#define __TERMINAL_H__

#include <sys/types.h>

#include <term_internal.h>

/*----------------------------------------------
 define special types 
 ----------------------------------------------*/

#define t_number	1
#define t_string	2
#define t_endoflist	0


extern char **argv;
extern char argc;

extern int    NumCmds;
extern struct command *MainCmd;
#define CmdTerminate (struct command){"",NULL,NULL,NULL}

/*----------------------------------------------
 declare functions 
 ----------------------------------------------*/

char *UpCaseStr(char *TarStr, const char *SrcStr);

void term_init(term_cl_t * clp);
void term_deinit(term_cl_t * clp);
long term_insert_command(struct command *Cmd, term_cl_t * clp);
long term_remove_command(struct command *Cmd, term_cl_t * clp);

int  term_transform_argumentline(struct arg **arg, char *line, term_cl_t * clp);
void term_free_argumentlist(struct arg *arg);

void term_print_argument(struct arg *arg,char *str);

#endif /* __TERMINAL_H__ */
