#ifndef __ACL_H
#define __ACL_H

/* REMEMBER TO ADAPT CHANGES TO BASE.CDL! */

/* A special acl object: only the super user has all permissions on this */
#define ACL_OBJ_SUPER				"super"

/* A special acl object: everyone has all permissions on this */
#define ACL_OBJ_ANYONE				""

#define ACL_OBJ_OEM                             ACL_OBJ_SUPER

#define ACL_OBJ_ACL				"acl"
#define ACL_OBJ_LONG_ACL			"User/Group Permissions"

#define ACL_OBJ_FIRMWARE			"fw"
#define ACL_OBJ_LONG_FIRMWARE			"Firmware Update"

#define ACL_OBJ_IPMI				"ipmi_s"
#define ACL_OBJ_LONG_IPMI			"IPMI Settings"

#define ACL_OBJ_IPMI_STATUS			"status_ipmi"
#define ACL_OBJ_LONG_IPMI_STATUS		"IPMI Sensor Status"

#define ACL_OBJ_IPMI_EVENTS			"events_ipmi"
#define ACL_OBJ_LONG_IPMI_EVENTS		"IPMI Event Log"

#define ACL_OBJ_KM				"km_s"
#define ACL_OBJ_LONG_KM				"Keyboard/Mouse Settings"

#define ACL_OBJ_KVM_S				"kvm_s"
#define ACL_OBJ_LONG_KVM_S			"KVM Settings"

#define ACL_OBJ_KVM_PORTS			"kvm"
#define ACL_OBJ_LONG_KVM_PORTS			"KVM Port Switch"

#define ACL_OBJ_UM				"um"
#define ACL_OBJ_LONG_UM				"User/Group Management"

#define ACL_OBJ_UM_PW				"um_pw"
#define ACL_OBJ_LONG_UM_PW			"Change Password"

#define ACL_OBJ_NET				"net_s"
#define ACL_OBJ_LONG_NET			"Network Settings"

#define ACL_OBJ_POWER_CONTROL			"pc"
#define ACL_OBJ_LONG_POWER_CONTROL		"Power Control"

#define ACL_OBJ_POWER_DEV_CONFIG		"pdc"
#define ACL_OBJ_LONG_POWER_DEV_CONFIG		"Power Device Configuration"

#define ACL_OBJ_POWER_CONTROL_DIRECT		"pc_direct"
#define ACL_OBJ_LONG_POWER_CONTROL_DIRECT	"Power Control (Direct)"

#define ACL_OBJ_POWER_SWITCH			"pc_s"
#define ACL_OBJ_LONG_POWER_SWITCH		"Power Control Settings"

#define ACL_OBJ_RESET				"reset"
#define ACL_OBJ_LONG_RESET			"Reset Device"

#define ACL_OBJ_AUTHOPT				"auth_s"
#define ACL_OBJ_LONG_AUTHOPT			"Authentication Settings"

#define ACL_OBJ_LOG_S				"log_s"
#define ACL_OBJ_LONG_LOG_S			"Log Settings"

#define ACL_OBJ_LOG_VIEW			"log_v"
#define ACL_OBJ_LONG_LOG_VIEW			"Log View"

#define ACL_OBJ_SECURITY			"security_s"
#define ACL_OBJ_LONG_SECURITY			"Security Settings"

#define ACL_OBJ_RC				"rc"
#define ACL_OBJ_LONG_RC				"Remote Console Access"

#define ACL_OBJ_RC_GENERAL			"rc_general"
#define ACL_OBJ_LONG_RC_GENERAL			"Remote Console General Settings"

#define ACL_OBJ_RC_ENCODING			"rc_s_enc"
#define ACL_OBJ_LONG_RC_ENCODING		"Remote Console Encoding Settings"

#define ACL_OBJ_RC_EXCLUSIVE			"rc_s_excl"
#define ACL_OBJ_LONG_RC_EXCLUSIVE		"Remote Console Exclusive Mode"

#define ACL_OBJ_RC_HOTKEYS			"rc_s_hk"
#define ACL_OBJ_LONG_RC_HOTKEYS			"Remote Console Hotkeys"

#define ACL_OBJ_RC_TYPE			        "rc_s_t"
#define ACL_OBJ_LONG_RC_TYPE  		        "Remote Console Type"

#define ACL_OBJ_RC_MONITOR_MODE			"rc_s_mm"
#define ACL_OBJ_LONG_RC_MONITOR_MODE		"Remote Console Monitor Mode"

#define ACL_OBJ_SERIAL				"serial_s"
#define ACL_OBJ_LONG_SERIAL			"Serial Settings"

#define ACL_OBJ_SNMP				"snmp_s"
#define ACL_OBJ_LONG_SNMP			"SNMP Settings"

#define ACL_OBJ_SSH				"ssh"
#define ACL_OBJ_LONG_SSH			"SSH Access"

#define ACL_OBJ_TELNET				"telnet"
#define ACL_OBJ_LONG_TELNET			"Telnet Access"

#define ACL_OBJ_TIME				"time_s"
#define ACL_OBJ_LONG_TIME			"Date/Time Settings"

#define ACL_OBJ_LANGUAGE			"language"
#define ACL_OBJ_LONG_LANGUAGE			"Language Settings"

#define ACL_OBJ_VFLOPPY				"vfloppy"
#define ACL_OBJ_LONG_VFLOPPY			"Virtual Floppy"

#define ACL_OBJ_VIDEO				"video_s"
#define ACL_OBJ_LONG_VIDEO			"Video Settings"

#define ACL_OBJ_VIDEO_ADVANCED			"vs_adv"
#define ACL_OBJ_LONG_VIDEO_ADVANCED		"Video Settings (Advanced)"

#ifdef PRODUCT_PDU
/* FIXME: for old webpages only! */
#define ACL_OBJ_PDU_OUTLET			"outlet_s"
#define ACL_OBJ_LONG_PDU_OUTLET		"PDU Outlet Status"

//#define ACL_OBJ_PDU_OUTLET_DETAIL			"outlet_detail"
//#define ACL_OBJ_LONG_PDU_OUTLET_DETAIL		"PDU Outlet Status Detail"

//#define ACL_OBJ_PDU_OUTLET_SETUP			"outlet_setup"
//#define ACL_OBJ_LONG_PDU_OUTLET_SETUP		"PDU Outlet Setup"
#endif

#endif /* __ACL_H */
