#ifndef _ERIC_FORMS_H
#define _ERIC_FORMS_H 1

#include <pp/cd.h>
#include <pp/profile.h>
#include "eric_form_vars.h"
#include "webs.h"
#include "templates.h"
#include "acl.h"
#include "eric_forms_str.h"

#define FORM_SETTINGS_PERM_DENIED	-1
#define FORM_SETTINGS_NOT_SUBMITTED	-2

#define FV_FLAG_ALLOW_EMPTY       (1<<0)
#define FV_FLAG_DONT_TRIM         (1<<1)
#define FV_FLAG_TAGABLE           (1<<2)
#define FV_FLAG_DONT_SAVE         (1<<3)
#define FV_FLAG_DONT_SAVE_EMPTY   (1<<4)
#define FV_FLAG_DONT_CLEAR	  (1<<5)
#define FV_FLAG_SKIP_VALIDATE     (1<<6)
#define FV_FLAG_ALLOW_COND_EMPTY  (1<<7)

#define FV_CFGKEY_MAX_LEN 255
#define FV_KEY_MAX_LEN     63

#define FV_SPEC static const form_var_spec_t fv_spec[]
#define CREATE_FH_INSTANCE(name, acl_object) \
    create_form_handler_instance(name, acl_object, fv_spec, sizeof(fv_spec) / sizeof(form_var_spec_t))
#define REGISTER_FH_INSTANCE_AND_RETURN(fh)				\
    {									\
	if (register_form_handler_instance(fh)) {			\
	    pp_log("%s(): %s\n", ___F, reg_form_handler_failed_msg);	\
	    return -1;							\
	}								\
	return 0;							\
    }

typedef enum {
    FV_TYPE_NONE,
    FV_TYPE_GLOBAL,
    FV_TYPE_GLOBAL_TAGABLE,
    FV_TYPE_USER,
    FV_TYPE_TARGET_USER,
} form_var_type_t;

/* ---- form handler ------------------------------------------------------- */

typedef struct form_handler_s form_handler_t;

typedef int (*form_hook_t)(webs_t wp, form_handler_t * fh);

typedef char* (*form_var_get_cb_t)(webs_t wp, pp_profile_type_t prof_type,
                                   const char *key, int i, const char *s,
                                   int *profile);
typedef int (*form_var_save_cb_t)(webs_t wp, pp_profile_type_t prof_type,
                                  const char *key, int i, const char *s,
                                  const char *value);
typedef int (*form_var_remove_cb_t)(webs_t wp, pp_profile_type_t prof_type,
                                    const char *key, int i, const char *s);
typedef pp_profile_type_t (*form_var_proftype_cb_t)(webs_t wp,
                                                    const form_var_t *fv);
                               
typedef enum {                  // e.g.
    FV_CB_INVALID_KEY,          // anyth[%I].ng ;-)
    FV_CB_PLAIN_KEY,            // network.mac
    FV_CB_IDX_KEY,              // serialport[%I]._c_
    FV_CB_ASSOC_KEY,            // 
    FV_CB_USER_KEY,             // user[%U].login
    FV_CB_USER_IDX_KEY,         // user[%U].rc.hotkey[%I].key
    FV_CB_USER_ASSOC_KEY,       // 
    FV_CB_GROUP_KEY,            // group[%G].name
    FV_CB_GROUP_IDX_KEY,        // 
    FV_CB_GROUP_ASSOC_KEY,      // group[%G].acl[%S]
    FV_CB_UNIT_KEY,             // 
    FV_CB_UNIT_IDX_KEY,         // 
    FV_CB_UNIT_ASSOC_KEY,       // 
    FV_CB_UNIT_PORT_KEY,        // 
    FV_CB_UNIT_PORT_IDX_KEY,    // 
    FV_CB_UNIT_PORT_ASSOC_KEY,  // 
#if defined(KIRA_RPC)
    FV_CB_OUTLET_KEY,           // bmc.rcp.outlet[%O].name
    FV_CB_OUTLET_IDX_KEY,       //
    FV_CB_OUTLET_ASSOC_KEY,     //
#endif /* KIRA_RPC */
} fv_cb_type_t;

#define FH_FLAG_SKIP_SAVE		(1<<0)
#define FH_FLAG_ABORT_AT_VALIDATE	(1<<1)
#define FH_FLAG_ABORT_AT_SAVE		(1<<2)

typedef struct fh_private_data_s fh_private_data_t;

typedef struct {
    const u_short id;
    const char * cfgkey;
    const char * elemkey;	// the element key in case of vec
} form_var_spec_t;

struct form_handler_s {
    const char * tmpl_name;
    const char * acl_object;
    form_var_t * fv_tmpl;
    form_var_t * fv;
    size_t fv_cnt;
    fh_private_data_t * private;
    form_hook_t authorize_hook;
    form_hook_t pre_validate_hook;
    form_hook_t post_validate_hook;
    form_hook_t post_save_hook;
    void (*private_free_hook)(void *);
    int disable_ldap;
};

struct form_var_s {
    u_short			id;
    char			fvname[FV_KEY_MAX_LEN]; // name used in webform
    const char *		label;
    char *		cfgkey;
    const char *		elemkey;	// the element key in case of vec
    union {
	const pp_cd_as_type_t *	realtype;	// the type used for validation
	const pp_cd_as_type_vector_tmpl_t * realtype_vec;
    };
    const pp_cd_as_type_t *	elemtype;	// the element type in case of vec
    const char *		acl_object;
    u_long			flags;
    u_short			val_cnt;
    u_short			val_cnt_max;
    union {
	const char *		s;	// single value
	const char **		m;	// multiple values
    } val;
    char **                     assoc_name;
    
    form_var_get_cb_t           get;
    form_var_save_cb_t          save;
    form_var_remove_cb_t        remove;
    form_var_proftype_cb_t      proftype;
};

extern const char * perm_denied_msg;
extern const char * internal_error_msg;
extern const char * reg_form_handler_failed_msg;
extern const char * reg_acl_obj_failed_msg;
extern pp_hash_t * form_handlers;

extern const char fv_vec_idx_deli;

int forms_init(void);

form_handler_t * lookup_form_handler(const char * tmpl_name);

int settings_form_header(webs_t wp, const char * acl_object_name,
			 const char * read_perm_name,
			 const char * write_perm_name);
void show_permission_denied_page(webs_t wp);
int parse_form_vars(webs_t wp);
int save_form_vars(webs_t wp);
void delete_form_vars(webs_t wp);
int adjust_webs_var(webs_t wp, form_var_t * fv);
char * get_config_var(webs_t wp, const char * var);
int remove_entries(webs_t wp, form_var_t * form_vars, u_int num_entries,
		   int * ids, u_int num_ids,
		   int (*to_be_removed)(form_var_t*, u_int));
int form_was_submitted(webs_t wp);
int form_button_clicked(webs_t wp, const char * var);
int form_var_is_disabled(webs_t wp, const form_var_t* fv);
void form_var_sz_name(const char* fvname, char* fvkey, size_t fvklen);
void form_var_vec_name(const char* fvname, u_int idx, char* fvkey,
		       size_t fvklen);
void form_var_assoc_name(const char* fvname, const char* idx, char* fvkey,
		         size_t fvklen);
const char* cfg_var_vecsz_key(const char* cfgkey, 
                              char* fvkey, size_t fvklen);
const char* cfg_var_vecelem_key(const char* veckey, const char* elemkey,
                                char* keybuf, size_t keylen);
void websSetSzVar(webs_t wp, const char* optname, size_t size);
void websSetVecVar(webs_t wp, const char* optname, u_int idx,
                   const char* optvalue);
void websSetAssocVar(webs_t wp, const char* optname, const char*  idx,
                     const char* optvalue);
void websSetIntVar(webs_t wp, const char *var, int value);
int form_var_vec_increase(webs_t wp, const char* fvname, int sz,
			  int inc, int bound, const char* fillvalue);

form_handler_t * create_form_handler_instance(const char * tmpl_name,
					      const char * acl_object,
					      const form_var_spec_t * fv_spec,
					      size_t fv_cnt);
void destroy_form_handler_instance(void * fh);
int register_form_handler_instance(form_handler_t * fh);
int form_handler(webs_t wp);
char * get_form_var_value_unsaved(webs_t wp, const char * tmpl_name, unsigned int fv_id);
int default_authorize_hook(webs_t wp, form_handler_t * fh);

void get_form_var_name(const char * tmpl_name, u_int fv_id, char * fv_name, size_t fv_name_len);

char * get_form_var_prefix(form_var_type_t type);
void delete_fh_form_vars(webs_t wp, form_handler_t * fh);
void fh_disable_validate_and_save(form_handler_t * fh, int fv_id_ignore);

int translator_init(void);

int login_form(webs_t wp);

#endif /* _ERIC_FORMS_H */
