#include <liberic_net.h>
#include <liberic_notify.h>
#if defined(PP_FEAT_REMOTE_CONSOLE)
#include <pp/rfb.h>
#endif /* PP_FEAT_REMOTE_CONSOLE */
#include <liberic_session.h>
#include <pp/cfg.h>
#include <pp/um.h>
#include <pp/bio.h>
#include <pp/ldap_prof.h>
#include <pp/intl.h>

#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"

int
login_form(webs_t wp)
{
    const char * fv_login;
    const char * fv_password;
    const char * fv_nickname;
    char ip_str[INET6_ADDRSTRLEN];
    int gid;
    log_event_t event;
    int ret = -1;
    int server_sid;
    int blocked_before = 0, blocked_after;
    int single_login = 0;
    eric_session_int_id_t s;

    // FIXME: Find a better way to throw the ldap caches away.
    pp_ldap_clear_caches();
    
    fv_login = websGetVar(wp, "login", "");
    fv_password = websGetVar(wp, "password", "");
    fv_nickname = websGetVar(wp, "nickname", "");
    
    pp_bio_get_peer_name(wp->bio, ip_str, sizeof(ip_str));
	    
    event.eventdata.logintrapdata.loginname = fv_login;
    event.eventdata.logintrapdata.remote_host = ip_str;

#if defined(OEM_BELKIN) && defined(PRODUCT_LARA)
    blocked_before = pp_um_user_is_blocked(fv_login, NULL);
#endif

    pp_cfg_is_enabled_nodflt(&single_login, "security.single_login");

    /* check if user already logged on */
    if(single_login && 0 != (s = eric_session_get_by_login(fv_login))) {
        /* release that session, we do not need it! */
        eric_session_release(s);
        
        /* FIXME! anyone wants another trap oid? */
        event.trapoid = "SecurityViolation";
	eric_notify_post_event(&event, "auth", PP_NOTIFY_EVENT_LEGACY); 
        
    	if (encoder_hook && encoder_hook->encoder_login_failure) {
    	    encoder_hook->encoder_login_failure(fv_login, ip_str);
    	}
	
	/* must be before call to websRedirect */
	/* we must include the word "failed" in any case here because
	   KVM Vision Viewer parses the website for it! */
	set_response(wp, ERIC_RESPONSE_ERROR, 
                     _("%s User already logged in. %s"),
		     "<input type=\"hidden\" name=\"bla\" value=\"User already logged in.\">",
                     /* must not be translated! */
                     /* we cannot use a HTML comment here because the code that
                        shows the response message also generates comments; that
                        will lead to double "-->" which doesn't work */
		     (pp_ldap_has_errno(errno) || pp_um_has_errno(errno)) ? _(pp_error_string(errno)) : "");
    } else
    /* check password */
    if (PP_ERR == pp_um_user_authenticate_with_ip_str(fv_login, fv_password,
                                                      PP_UM_AUTH_NO_FLAGS,
                                                      ip_str, &server_sid, 
						      &gid)) {
        /* failure */
        int auth_errno = errno; // preserve errno from authenticate

	blocked_after = pp_um_user_is_blocked(fv_login, NULL);
	if (!blocked_before && blocked_after) {
	    /* user has just been blocked */
	    event.trapoid = "UserBlocked";
	} else {
	    /* still blocked or normal failure */
	    event.trapoid = "Loginfailed";
#if defined(PRODUCT_KX2)
	    event.trapname = "userAuthenticationFailure";
	    event.objectname = "DKX";
	    event.objectinstance = "DominionKX";
	    event.eventcode = ERIC_EC_Access_Login_Failed;
#endif
	}
	eric_notify_post_event(&event, "auth", PP_NOTIFY_EVENT_LEGACY); 

    	if (encoder_hook && encoder_hook->encoder_login_failure) {
    	    encoder_hook->encoder_login_failure(fv_login, ip_str);
    	}
	
	/* must be before call to websRedirect */
	/* we must include the word "failed" in any case here because
	   KVM Vision Viewer parses the website for it! */
	set_response(wp, ERIC_RESPONSE_ERROR, _("%s Authentication failed. %s"),
		     "<input type=\"hidden\" name=\"bla\" value=\"Authentication failed.\">",
		         /* must not be translated! */
		         /* we cannot use a HTML comment here because the code that
		            shows the response message also generates comments; that
		            will lead to double "-->" which doesn't work */
		     (pp_ldap_has_errno(auth_errno)
                      /* FIXME: || pp_um_has_errno(auth_errno) */) ?
                     _(pp_error_string(auth_errno)) : "");
    } else {
	char cookie[ERIC_ID_LENGTH + 22 + 1];
	char* cookie_ptr = NULL;
	eric_webs_session_data_t * sd;
	int error;
        
	if (wp->auth_ok) {
	    // user logged in again from the same browser as other user
	    // cookie (of old session) is sent,
	    // session exists - delete old session to fix #718 and prevent, that
	    // an user access the frontend with as user of the old session and
	    // not as the actually authenticated user
	    if (wp->session) {
		eric_net_ssl_auth_logout(wp->bio);
#if defined(PP_FEAT_REMOTE_CONSOLE)
		pp_rfb_do_disconnect(wp->session);
#endif
		eric_session_release(wp->session);
	    }
	}
	
	event.trapoid = "Loginsuccess";       
#if defined(PRODUCT_KX2)
	event.trapname = "userLogin";
	event.objectname = "DKX";
	event.objectinstance = "DominionKX";
	event.eventcode = ERIC_EC_Access_Login;
#endif
	eric_notify_post_event(&event, "auth", PP_NOTIFY_EVENT_LEGACY);

	if ((sd = eric_webs_alloc_session_data()) != NULL) {
	    s = eric_session_create(fv_login, ip_str, fv_nickname, server_sid, &error);
	    if (s != 0) {
		snprintf(cookie, sizeof(cookie), PP_COOKIE_NAME "=%s; path=/",
			 eric_session_get_id(s));
		cookie_ptr = cookie;

		eric_session_set_gid(s, gid);
		sd->session = s;
		pp_hash_set_entry_i(webs_session_data, s, sd,
				    eric_webs_free_session_data);
		eric_session_add_destroy_cb(s,
					    eric_webs_free_session_data_by_id);
#if defined(PP_FEAT_AUTH_RADIUS)		
		pp_um_radius_acct_request(fv_login, server_sid, RAD_START);
#endif		
	       
		eric_redirect(wp, "/home.asp", cookie_ptr);
		ret = 0;
	    } else {
		if (error == ERIC_SESSION_ERR_MAXIMUM_REACHED) {
		    set_response(wp, ERIC_RESPONSE_ERROR, _("Maximum number of %d open sessions reached."),
				 eric_session_get_max_count());
		}
	    }
	}
    }

    return ret;
}
