#include "gd_images.h"
#include "wsIntrn.h"

#include <pp/ipmi.h>

#include <gd.h>
#include <gdfontmb.h>
#include <gdfontl.h>
#include <gdfonts.h>

static int
color_add(int c1,int c2,int w1,int w2)
{
    int c1a=(c1>>24)&0x7f,
	c1r=(c1>>16)&0xff,
	c1g=(c1>>8)&0xff,
	c1b=c1&0xff,
	c2a=(c2>>24)&0x7f,
	c2r=(c2>>16)&0xff,
	c2g=(c2>>8)&0xff,
	c2b=c2&0xff;
    return gdTrueColorAlpha(
	    (c1r*w1+c2r*w2)/(w1+w2),
	    (c1g*w1+c2g*w2)/(w1+w2),
	    (c1b*w1+c2b*w2)/(w1+w2),
	    (c1a*w1+c2a*w2)/(w1+w2));
}

static void
draw_grad_h(gdImagePtr im,int x1,int y1,int x2,int y2,int c1,int c2)
{
    int i=y1;
    for(;i<=y2;i++)
	gdImageLine(im,x1,i,x2,i,color_add(c1,c2,y2-i,i-y1));
}

static void
draw_grad_v(gdImagePtr im,int x1,int y1,int x2,int y2,int c1,int c2)
{
    int i=x1;
    for(;i<=x2;i++)
	gdImageLine(im,i,y1,i,y2,color_add(c1,c2,x2-i,i-x1));
}

static void
draw_bevel(gdImagePtr im,int x1,int y1,int x2,int y2,int border,int c)
{
    gdPoint p1[]={
	{x1,y1},
	{x2,y1},
	{x2-border,y1+border},
	{x1+border,y1+border}
    };
    gdPoint p2[]={
	{x1,y1},
	{x1,y2},
	{x1+border,y2-border},
	{x1+border,y1+border}
    };
    gdPoint p3[]={
	{x2,y1},
	{x2,y2},
	{x2-border,y2-border},
	{x2-border,y1+border}
    };
    gdPoint p4[]={
	{x2,y2},
	{x1,y2},
	{x1+border,y2-border},
	{x2-border,y2-border}
    };

    gdImageFilledPolygon(im,p1,4,color_add(c,0xffffff,8,2));
    gdImageFilledPolygon(im,p2,4,color_add(c,0xffffff,9,1));
    gdImageFilledPolygon(im,p3,4,color_add(c,0xffffff,4,6));
    gdImageFilledPolygon(im,p4,4,color_add(c,0xffffff,3,7));
}

#define TOSCALE(x) HEIGHT-HEIGHT*(x-min)/(max-min)

const int WIDTH=100,HEIGHT=300;

static int
output(gdImagePtr im,int offset,int scale,const char * form,const char * unit,
	int val,
	int min,int max,
	int upper_crit,int lower_crit,
	int upper_non,int lower_non,
	int major_step,int minor_step)
{
    int i;

    draw_grad_v(im,0,0,WIDTH/2,HEIGHT-1,0xffffff,0);
    draw_grad_v(im,WIDTH/2,0,WIDTH-1,HEIGHT-1,0,0xffffff);
    
    gdImageFilledRectangle(im,WIDTH/5,0,WIDTH-WIDTH/5,HEIGHT-1,0xff0000);
    gdImageFilledRectangle(im,WIDTH/5,TOSCALE(upper_non),WIDTH-WIDTH/5,TOSCALE(lower_non),0xffff00);
    gdImageFilledRectangle(im,WIDTH/5,TOSCALE(upper_crit),WIDTH-WIDTH/5,TOSCALE(lower_crit),0xff00);
    gdImageFilledRectangle(im,WIDTH/4,0,WIDTH-WIDTH/4,HEIGHT-1,0xffffff);

    for(i=min+major_step;i<max;i+=major_step)
    {
	char buf[50];
	gdImageLine(im,WIDTH/5,TOSCALE(i),WIDTH/3,TOSCALE(i),0);
	gdImageLine(im,WIDTH-WIDTH/3,TOSCALE(i),WIDTH-WIDTH/5,TOSCALE(i),0);
	sprintf(buf,form,(float)(i-offset)/scale);
	gdFontPtr f=gdFontGetMediumBold();
	gdImageString(im,f,WIDTH/2-strlen(buf)*f->w/2,TOSCALE(i)-f->h/2,(unsigned char*)buf,0);
    }

    for(i=min+minor_step;i<max;i+=minor_step)
    {
	gdImageLine(im,WIDTH/5,TOSCALE(i),WIDTH/4,TOSCALE(i),0);
	gdImageLine(im,WIDTH-WIDTH/4,TOSCALE(i),WIDTH-WIDTH/5,TOSCALE(i),0);
    }

    gdImageLine(im,WIDTH/7,TOSCALE(val)-1,WIDTH-WIDTH/7,TOSCALE(val)-1,0xfff0f0);
    gdImageLine(im,WIDTH/7,TOSCALE(val),WIDTH-WIDTH/7,TOSCALE(val),0xff0000);
    gdImageLine(im,WIDTH/7,TOSCALE(val)+1,WIDTH-WIDTH/7,TOSCALE(val)+1,0x600000);
    
    draw_grad_h(im,WIDTH/5,0,WIDTH-WIDTH/5,HEIGHT/2,0x40000000,0x7f000000);
    draw_grad_h(im,WIDTH/5,HEIGHT/2,WIDTH-WIDTH/5,HEIGHT-1,0x7f000000,0x40000000);

    gdPoint tri1[]={
	{WIDTH/7,TOSCALE(val)-4},
	{WIDTH/7,TOSCALE(val)+4},
	{WIDTH/7+5,TOSCALE(val)}
    };
    gdPoint tri2[]={
	{WIDTH-WIDTH/7,TOSCALE(val)-4},
	{WIDTH-WIDTH/7,TOSCALE(val)+4},
	{WIDTH-WIDTH/7-5,TOSCALE(val)}
    };
    gdImageFilledPolygon(im,tri1,3,0);
    gdImageFilledPolygon(im,tri2,3,0);

    {
	gdFontPtr f=gdFontGetSmall();
	gdImageString(im,f,WIDTH/2-strlen(unit)*f->w/2,HEIGHT-20,(const unsigned char*)unit,0x202020);
    }

    draw_bevel(im,0,0,WIDTH-1,HEIGHT-1,3,0);
    
    return 0;
}

static void
image_download_cb(webs_t wp)
{
    if (wp->download_image != NULL &&
	websWriteBlock(wp, wp->download_image, wp->numbytes) > 0) {

	wp->written += wp->numbytes;
    }

    free(wp->download_image);
    wp->download_image=NULL;

    if (wp->written >= wp->numbytes) {
	websDone(wp, 200);
    } else {
	websDone(wp, 0);
    }
}


static void
send_rpc_image(webs_t wp,const char * name)
{
    gdImagePtr im;
    
    im=gdImageCreateTrueColor(WIDTH,HEIGHT);

    {
	pp_ipmi_return_t ipmi_ret;
	u_int i, sensor_cnt = 0;
	int id=atoi(name);

	memset(&ipmi_ret, 0, sizeof(ipmi_ret));

	if (pp_ipmi_send_command(PP_IPMI_CMD_SDR, PP_IPMI_SDR_SUBCMD_LIST,
		    NULL, &ipmi_ret, NULL, wp->user) != 0) {
	    pp_log("Error: Could not query Sensor repository.");
	    goto bail;
	}

	sensor_cnt = vector_size(ipmi_ret.data.sdr_list);

	if (sensor_cnt == 0) {
	    pp_log("No sensors found.");
	    goto bail;
	}

	for (i = 0; i < sensor_cnt; i++) {
	    pp_ipmi_sdr_list_entry_t *entry = vector_get(ipmi_ret.data.sdr_list, i);

	    if (!entry) {
		pp_log("%s(): Error: could not read entry %u\n", ___F, i);
		goto bail;
	    }

	    if(entry->sdr_id!=id)
		continue;

	    if (entry->type == PP_IPMI_SENSOR_TYPE_FULL) {
		if (entry->data.full.reading_present == PP_IPMI_SENSOR_READING_OK) {
		    char *unit=strdup(pp_strstream_buf(&entry->data.full.unit));
		    int j=0,e=1;
		    for(;j>entry->data.full.cim_unit_modifier;j--) e*=10;
		    output(im,
			    0,
			    e,
			    "%.1f",
			    unit,
			    entry->data.full.reading.cim_value,
			    entry->data.full.minimum_sensor_range.cim_value,
			    entry->data.full.maximum_sensor_range.cim_value,
			    entry->data.full.upper_critical.cim_value,
			    entry->data.full.lower_critical.cim_value,
			    entry->data.full.upper_non_recoverable.cim_value,
			    entry->data.full.lower_non_recoverable.cim_value,
			    e,
			    e/5);
		    free(unit);
		} 		
	    }
	}

bail:
	pp_ipmi_cleanup_ret(&ipmi_ret);
    }

    wp->download_image=gdImageGifPtr(im,&wp->numbytes);
    gdImageDestroy(im);

    strcpy(wp->type, "image/gif");
    wp->download_cb = image_download_cb;
}

    void
send_gd_content(webs_t wp,const char * name)
{
    if(strstr(name,"rpc_")==name)
	send_rpc_image(wp,name+4);
}
