#ifndef __TEMPLATES_H
#define __TEMPLATES_H 1

/* NOTE: no includes here - filepp will stumble and fall */

int acl_common_tmpl_init(void);

#define TEMPLATE_ACL "acl"
int acl_tmpl_init(void);

#define TEMPLATE_LANGUAGE "setlanguage"
int language_tmpl_init(void);

#define TEMPLATE_ACL_PORTS "aclports"
int acl_ports_tmpl_init(void);

#define TEMPLATE_ACL_OUTLETS "acloutlets"
extern int acl_outlets_tmpl_init(void);

#define TEMPLATE_ACL_XPORTS "aclxports"
int acl_xports_tmpl_init(void);

#define TEMPLATE_ATX_RESET_DURATIONS "atxresetdurations"
int atx_reset_durations_tmpl_init(void);

int auth_common_tmpl_init(void);

#define TEMPLATE_AUTH "auth"
int auth_tmpl_init(void);

#define TEMPLATE_AUTH_LDAP "authldap"
int auth_ldap_tmpl_init(void);

#define TEMPLATE_AUTH_RADIUS "authradius"
int auth_radius_tmpl_init(void);

int device_prod_info_tmpl_init(void);

int firmware_common_tmpl_init(void);

#define TEMPLATE_DEBUG_MEMORY "debugmemory"
int debug_memory_tmpl_init(void);

#define TEMPLATE_DEBUG_MISC "debugmisc"
int debug_misc_tmpl_init(void);

#define TEMPLATE_DEBUG_VSC "debugvsc"
int debug_vsc_tmpl_init(void);

#define TEMPLATE_FIRMWARE_UPLOAD "firmwareupload"
int firmware_upload_tmpl_init(void);

#define TEMPLATE_FIRMWARE_UPDATE "firmwareupdate"
int firmware_update_tmpl_init(void);

#define TEMPLATE_FLASHDISK_USAGE "flashdiskusage"
int flashdisk_usage_tmpl_init(void);

#define TEMPLATE_GENERAL_PING "generalping"
int general_ping_tmpl_init(void);

#define TEMPLATE_IPMI_ALERTS "ipmialerts"
int ipmi_alerts_tmpl_init(void);

#define TEMPLATE_IPMI_FILTER_LIST "ipmifilterlist"
int ipmi_filter_list_tmpl_init(void);

#define TEMPLATE_IPMI_POLICY_LIST "ipmipolicylist"
int ipmi_policy_list_tmpl_init(void);

#define TEMPLATE_IPMI_POLICY_EDIT "ipmipolicyedit"
int ipmi_policy_edit_tmpl_init(void);

#define TEMPLATE_IPMI_LAN_DEST_LIST "ipmilandestlist"
int ipmi_lan_dest_list_tmpl_init(void);

#define TEMPLATE_IPMI_FILTER_EDIT "ipmifilteredit"
int ipmi_filter_edit_tmpl_init(void);

#define TEMPLATE_IPMI_LAN_DEST_EDIT "ipmilandestedit"
int ipmi_lan_dest_edit_tmpl_init(void);

#define TEMPLATE_IPMI_LAN_DEST_OPTIONS "ipmilandestoptions"
int ipmi_lan_dest_options_tmpl_init(void);

#define TEMPLATE_IPMI_CHASSIS_CONTROL "ipmichassiscontrol"
int ipmi_chassis_control_tmpl_init(void);
int ipmi_chassis_power_control(webs_t wp, int command, const char **errstr);

#define TEMPLATE_IPMI_CHASSIS_INFO "ipmichassisinfo"
int ipmi_chassis_info_tmpl_init(void);

#define TEMPLATE_IPMI_CHASSIS_LOCATOR "ipmichassislocator"
int ipmi_chassis_locator_tmpl_init(void);

#define TEMPLATE_IPMI_CHASSIS_OPMA "ipmichassisopma"
int ipmi_chassis_opma_tmpl_init(void);

#define TEMPLATE_IPMI_EVENTS "ipmievents"
int ipmi_events_tmpl_init(void);

#define TEMPLATE_IPMI_SENSORS "ipmisensors"
int ipmi_sensors_tmpl_init(void);

#define TEMPLATE_IPMI_FRU_INFO "ipmifruinfo"
int ipmi_fru_info_tmpl_init(void);

#define TEMPLATE_IPMI_SEL "ipmisel"
int ipmi_sel_tmpl_init(void);
int ipmi_sel_clear_log(webs_t wp);

#define TEMPLATE_IPMI_STATUS "ipmistatus"
int ipmi_status_tmpl_init(void);

#define TEMPLATE_IPMI "ipmi"
int ipmi_tmpl_init(void);

#define TEMPLATE_KM "km"
int km_tmpl_init(void);

int kvm_common_tmpl_init(void);
void kvm_get_portname_from_index(int id, char *name, int name_max);

#define TEMPLATE_KVM "kvm"
int kvm_tmpl_init(void);

#define TEMPLATE_KVM_PORT_LIST "kvmportlist"
int kvm_port_list_tmpl_init(void);

#define TEMPLATE_KVM_POWER_CTRL "kvmpowerctrl"
int kvm_power_ctrl_tmpl_init(void);

int log_common_tmpl_init(void);

#define TEMPLATE_LOG "log"
int log_tmpl_init(void);

#define TEMPLATE_LOG_ASSIGN "logassign"
int log_assign_tmpl_init(void);

#define TEMPLATE_LOG_LIST "loglist"
int log_list_tmpl_init(void);

#define TEMPLATE_LOG_NFS "lognfs"
int log_nfs_tmpl_init(void);

#define TEMPLATE_LOG_SMTP "logsmtp"
int log_smtp_tmpl_init(void);

#define TEMPLATE_LOG_SNMP "logsnmp"
int log_snmp_tmpl_init(void);

#define CHECK_AGAINST_LAN	(1<<0)
#define CHECK_AGAINST_MODEM	(1<<1)
int net_common_tmpl_init(void);
int net_common_check_ports(webs_t wp);
int net_common_check_ips(webs_t wp,
			 const char * check_ip_str,
			 const char * check_mask_str,
			 int type,
			 const char * msg);

#define TEMPLATE_NET_BASIC "netbasic"
int net_basic_tmpl_init(void);

#define TEMPLATE_NET_DYNDNS "netdyndns"
int net_dyndns_tmpl_init(void);

#define TEMPLATE_NET_LANIF "netlanif"
int net_lanif_tmpl_init(void);

#define TEMPLATE_NET_MISC "netmisc"
int net_misc_tmpl_init(void);

#define TEMPLATE_NET_WLAN "netwlan"
int net_wlan_tmpl_init(void);

#define TEMPLATE_NET_WLAN_STATUS "netwlanstatus"
int net_wlan_status_tmpl_init(void);

#define TEMPLATE_NET_WLAN_WEP "netwlanwep"
int net_wlan_wep_tmpl_init(void);

#define TEMPLATE_NET_WLAN_WPA "netwlanwpa"
int net_wlan_wpa_tmpl_init(void);

#define TEMPLATE_NET_WLAN_WPA_PSK "netwlanwpapsk"
int net_wlan_wpa_psk_tmpl_init(void);

#define TEMPLATE_NET_WLAN_WPA_EAP_PEAP_MSCHAPV2 "netwlanwpaeappeapmschapv2"
int net_wlan_wpa_eap_peap_mschapv2_tmpl_init(void);

#define TEMPLATE_OEM_DEV "oemdev"
int oem_dev_tmpl_init(void);

#define TEMPLATE_OEM_MISC "oemmisc"
int oem_misc_tmpl_init(void);

#define TEMPLATE_OEM_UPLOAD "oemupload"
int oem_upload_file_tmpl_init(void);

int power_common_tmpl_init(void);

int power_control_common_tmpl_init(void);
int power_control_common_power_switch_login(webs_t wp, u_int port_id);

#define TEMPLATE_POWER_CONTROL_PORTS "powercontrolports"
int power_control_ports_tmpl_init(void);

#define TEMPLATE_POWER_CONTROL_DIRECT "powercontroldirect"
int power_control_direct_tmpl_init(void);

#define TEMPLATE_POWER_CONTROL_STATE "powercontrolstate"
int power_control_state_tmpl_init(void);

#define TEMPLATE_POWER_CONTROL_PSU_ADAPT "powercontrolpsuadapt"
int power_control_psu_adapt_tmpl_init(void);

#define TEMPLATE_POWER_CONTROL_INTERN "powercontrolintern"
int power_control_intern_tmpl_init(void);

#define TEMPLATE_POWER_CONTROL_IPMI "powercontrolipmi"
int power_control_ipmi_tmpl_init(void);

#define TEMPLATE_POWER_DEVICE_CFG "powerdevicecfg"
int power_device_cfg_tmpl_init(void);

#define TEMPLATE_POWER_SWITCH "powerswitch"
int power_switch_tmpl_init(void);

#define TEMPLATE_POWER_CYCLE_OFFTIME "powercycleofftime"
int power_cycle_offtime_tmpl_init(void);

#define TEMPLATE_PSWITCH_STATUS "pswitchstatus"
int pswitch_status_tmpl_init(void);

#define TEMPLATE_RC "rc"
int rc_tmpl_init(void);

#define TEMPLATE_RC_ENCODING "rcencoding"
int rc_encoding_tmpl_init(void);

#define TEMPLATE_RC_GENERAL "rcgeneral"
int rc_general_tmpl_init(void);

#define TEMPLATE_RC_HOME_REFRESH "rchomerefresh"
int rc_home_refresh_tmpl_init(void);

#define TEMPLATE_RC_HOTKEYS "rchotkeys"
int rc_hotkeys_tmpl_init(void);

#define TEMPLATE_RC_MISC "rcmisc"
int rc_misc_tmpl_init(void);

#define TEMPLATE_RC_MOUSE_HOTKEY "rcmousehotkey"
int rc_mouse_hotkey_tmpl_init(void);

#define TEMPLATE_RC_PREVIEW "rcpreview"
int rc_preview_tmpl_init(void);

#define TEMPLATE_RC_TYPE "rctype"
int rc_type_tmpl_init(void);

#define TEMPLATE_RESET "reset"
int reset_tmpl_init(void);

#ifdef PRODUCT_PDU
int rpc_common_tmpl_init(void);
void rpc_common_tmpl_cleanup(void);

#define TEMPLATE_RPC_ALERT_DESTS "rpcalertdests"
int rpc_alert_dests_tmpl_init(void);

#define TEMPLATE_RPC_ALERT_EVENTS "rpcalertevents"
int rpc_alert_events_tmpl_init(void);

#define TEMPLATE_RPC_ALERT_POLICIES "rpcalertpolicies"
int rpc_alert_policies_tmpl_init(void);

#define TEMPLATE_RPC_OUTLET_DETAIL "rpcoutdetail"
int rpc_outlet_detail_tmpl_init(void);

#define TEMPLATE_RPC_OUTLET_LIST "rpcoutlist"
int rpc_outlet_list_tmpl_init(void);

#define TEMPLATE_RPC_OUTLET_SETUP "rpcoutset"
int rpc_outlet_setup_tmpl_init(void);
#endif

int sec_common_tmpl_init(void);

#define TEMPLATE_SEC_ANTIBF "secantibf"
int sec_antibf_tmpl_init(void);

#define TEMPLATE_SEC_CRYPT_WEB "seccryptweb"
extern int sec_crypt_web_tmpl_init(void);

#define TEMPLATE_SEC_CRYPT_KVM "seccryptkvm"
extern int sec_crypt_kvm_tmpl_init(void);

#define TEMPLATE_SEC_FW "secfw"
int sec_fw_tmpl_init(void);

#define TEMPLATE_SEC_GACL "secgacl"
int sec_group_acl_tmpl_init(void);

#define TEMPLATE_SEC_LOGLIM "secloglim"
int sec_loglim_tmpl_init(void);

#define TEMPLATE_SEC_SERVER_CERT_CSR "secservercertcsr"
int sec_server_cert_csr_tmpl_init(void);

#define TEMPLATE_SEC_SERVER_CERT_UPLOAD "secservercertupload"
int sec_server_cert_upload_tmpl_init(void);

int sec_server_cert_common_tmpl_init(void);

#define TEMPLATE_SEC_SPW "secspw"
int sec_strong_pw_tmpl_init(void);

int serial_common_tmpl_init(void);

#define TEMPLATE_SERIAL_1 "serial1"
int serial_1_tmpl_init(void);

#define TEMPLATE_SERIAL_2 "serial2"
int serial_2_tmpl_init(void);

#define TEMPLATE_SERIAL_BLADE "serialblade"
int serial_blade_tmpl_init(void);

#define TEMPLATE_SMTP "smtp"
int smtp_tmpl_init(void);

#define TEMPLATE_SN "sn"
int sn_tmpl_init(void);

#define TEMPLATE_SNMP_AGENT "snmpagent"
int snmp_agent_tmpl_init(void);

#define TEMPLATE_SSH "ssh"
int ssh_tmpl_init(void);

#define TEMPLATE_TARGET_LIST "targetlist"
int target_list_tmpl_init(void);

#define TEMPLATE_TELNET "telnet"
int telnet_tmpl_init(void);

int time_common_tmpl_init(void);

#define TEMPLATE_TIME "time"
int time_tmpl_init(void);

#define TEMPLATE_TIME_LOCAL "timelocal"
int time_local_tmpl_init(void);

#define TEMPLATE_TIME_NTP "timentp"
int time_ntp_tmpl_init(void);

int um_common_tmpl_init(void);

#define TEMPLATE_UM_GROUPS "umgroups"
int um_groups_tmpl_init(void);

#define TEMPLATE_UM_PRINCIPALS "umprincipals"
int um_principals_tmpl_init(void);

#define TEMPLATE_UM_PWCHANGE "umpwchange"
int um_pwchange_tmpl_init(void);

#define TEMPLATE_UM_USERS "umusers"
int um_users_tmpl_init(void);

int vfloppy_common_tmpl_init(void);
void vfloppy_download_cb(webs_t wp);

#define TEMPLATE_VFLOPPY_ACTIVE "vfloppyactive"
int vfloppy_active_tmpl_init(void);

#define TEMPLATE_VFLOPPY_EXTERN "vfloppyextern"
int vfloppy_extern_tmpl_init(void);

#define TEMPLATE_VFLOPPY_INTERN "vfloppyintern"
int vfloppy_intern_tmpl_init(void);

#define TEMPLATE_VFLOPPY_OPTIONS "vfloppyoptions"
int vfloppy_options_tmpl_init(void);

#define TEMPLATE_VFLOPPY_DRVREDIR "vfloppydrvredir"
int vfloppy_drvredir_tmpl_init(void);

int video_common_tmpl_init(void);

#define TEMPLATE_VIDEO_ADC "videoadc"
int video_adc_tmpl_init(void);

#define TEMPLATE_VIDEO_CUSTOM_MODES "videocustommodes"
int video_custom_modes_tmpl_init(void);

#define TEMPLATE_VIDEO_LOCAL_PORT "videolocalport"
int video_local_port_tmpl_init(void);

#define TEMPLATE_VIDEO_PANEL "videopanel"
int video_panel_tmpl_init(void);

#endif /* __TEMPLATES_H */

