#include <sys/ioctl.h>
#include <pp/kvm.h>
#include <pp/powerswitch.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#if defined(PP_FEAT_POWER_CTRL_ENABLE)

FV_SPEC = {
    {
	id:		FV_ID_PS_ATX_RESET_DURATION,
	cfgkey:		"ps.internal.reset_duration"
    },
    {
	id:		FV_ID_PS_ATX_POWER_SHORT_DURATION,
	cfgkey:		"ps.internal.power_short_duration"
    },
    {
	id:		FV_ID_PS_ATX_POWER_LONG_DURATION,
	cfgkey:		"ps.internal.power_long_duration"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
atx_reset_durations_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_ATX_RESET_DURATIONS, ACL_OBJ_POWER_SWITCH);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    char * atx_enabled_str = get_form_var_value_unsaved(wp, TEMPLATE_POWER_SWITCH, FV_ID_PS_ATX_ENABLED);
    if (pp_strcmp_safe(atx_enabled_str, "yes")) fh_disable_validate_and_save(fh, -1);
    free(atx_enabled_str);

    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int atx_reset_durations_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
