#include <dirent.h>
#include <sys/vfs.h>
#include <pp/flash_access.h>
#include "eric_util.h"
#include "eric_forms.h"
#include "wsIntrn.h"

/* do not print links to pages but allow direct deletion of files */
#define noFD_FOLDERS_BROWSABLE

FV_SPEC = {
};

static int get_fd_usage_asp(int eid, webs_t wp, int argc, char **argv);
static int get_fd_free_asp(int eid, webs_t wp, int argc, char **argv);
static int get_fd_folders_asp(int eid, webs_t wp, int argc, char **argv);
static int browse_fd_folder_asp(int eid, webs_t wp, int argc, char **argv);
static int print_fd_folder_asp(int eid, webs_t wp, int argc, char **argv);

#ifdef FD_FOLDERS_BROWSABLE
static int pre_validate_hook(webs_t wp, form_handler_t * fh);
#endif /* FD_FOLDERS_BROWSABLE */

static char* byte_to_string(long bytes, char *str, int length);

/* which folders should be browsable for file deletion? */
static const char *browsable[] = { "oem" };
#ifdef FD_FOLDERS_BROWSABLE
static const char *browse_prefix = "action_browse_";
static const char *remove_prefix = "action_remove_";
static const char *generic_link = "<input type=\"submit\" name=\"%s%s\" value=\"%s\">";
#else /* FD_FOLDERS_BROWSABLE */
/* which pages are assigned to browsable folders? (same order!!!) */
static const char *browse_page[] = { "__oem.asp" };
#endif /* FD_FOLDERS_BROWSABLE */

int
flashdisk_usage_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("getFdUsage", get_fd_usage_asp);
    websAspDefine("getFdFree", get_fd_free_asp);
    websAspDefine("getFdFolders", get_fd_folders_asp);
    websAspDefine("browseFdFolder", browse_fd_folder_asp);
    websAspDefine("printFdFolder", print_fd_folder_asp);

/* FIXME: TODO create ACL object for this... */
    fh = CREATE_FH_INSTANCE(TEMPLATE_FLASHDISK_USAGE, ACL_OBJ_ANYONE);
    
#ifdef FD_FOLDERS_BROWSABLE
    fh->pre_validate_hook = pre_validate_hook;
#endif /* FD_FOLDERS_BROWSABLE */

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

#ifdef FD_FOLDERS_BROWSABLE
static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    char **action_vars;
    int lpre, lpre2, i;
    U130_int j;
    
    if ((action_vars = websSearchVars(wp, browse_prefix)) != NULL) {
        lpre = strlen(browse_prefix);
        for (i = 0; action_vars[i] != NULL; ++i) {
            if (action_vars[i][lpre] != '\0') {
                /* check again, if its really browsable... */
                for (j = 0; j < sizeof(browsable); ++j) {
                    if (!strcmp(action_vars[i] + lpre, browsable[j])) {
                        websSetVar(wp, "browse_fd_folder", action_vars[i] + lpre);
                        wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
                        return 0;
                    }
		}
	    }
	}
    }

    if ((action_vars = websSearchVars(wp, remove_prefix)) != NULL) {
        lpre = strlen(remove_prefix);
        for (i = 0; action_vars[i] != NULL; ++i) {
            if (action_vars[i][lpre] != '\0') {
                /* check again, if its really, really, really browsable... */
                for (j = 0; j < sizeof(browsable); ++j) {
                    lpre2 = strlen(PP_FA_ROOT);
                    if (!strncmp(action_vars[i] + lpre, PP_FA_ROOT, lpre2)) {
                        if (!strncmp(action_vars[i] + lpre + lpre2,
				     browsable[j], strlen(browsable[j]))) {
                            return (remove(action_vars[i] + lpre));
			}
		    }
                }
	    }
	}
    }

    return 0;
}
#endif /* FD_FOLDERS_BROWSABLE */

static int
get_fd_usage_asp(int eid, webs_t wp UNUSED, int argc, char **argv)
{
    char dir[PATH_MAX];
   
    if (argc == 1) {
        snprintf(dir, sizeof(dir), "%s%s", PP_FA_ROOT, argv[0]);
        ejSetResult(eid, byte_to_string(pp_fa_du(dir), dir, PATH_MAX));
    }
    
    return 0;
}

static int
get_fd_free_asp(int eid, webs_t wp UNUSED, int argc, char **argv)
{
    char dir[PATH_MAX];
   
    if (argc == 1) {
        snprintf(dir, sizeof(dir), "%s%s", PP_FA_ROOT, argv[0]);
        ejSetResult(eid, byte_to_string(pp_fa_df(1), dir, PATH_MAX));
    }
    
    return 0;
}

static int
get_fd_folders_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
    DIR *dir;
    struct dirent *entry;
    struct stat statbuf;
    u_int folders_sz = 0;
    char var[FV_KEY_MAX_LEN+1];
    char dirstr[PATH_MAX];

    dir = opendir(PP_FA_ROOT);
    if (dir) {
        while ((entry = readdir(dir))) {
            snprintf(dirstr, sizeof(dirstr), "%s%s", PP_FA_ROOT, entry->d_name);
            if (!strcmp(entry->d_name, "..")
		|| !strcmp(entry->d_name, ".")
		|| lstat(dirstr, &statbuf) != 0) {
                continue;
	    }
            if (S_ISDIR(statbuf.st_mode)) {
                snprintf(var, sizeof(var), "fd_folders_%u", folders_sz++);
                websSetVar(wp, var, entry->d_name);
            }
        }
    }
    closedir(dir);
    snprintf(var, sizeof(var), "%u", folders_sz);
    websSetVar(wp, "fd_folders_sz", var);

    return 0;
}

#ifdef FD_FOLDERS_BROWSABLE

static int
dir_is_empty(const char *dirstr)
{
    DIR *dir;
    struct dirent *entry;
    int ret = 1; // empty

    if ((dir = opendir(dirstr)) != NULL) {
        while ((entry = readdir(dir))) {
            if (!strcmp(entry->d_name, "..")
		|| !strcmp(entry->d_name, ".")) {
                continue;
	    }
            /* we got a dirent which is neither . nor .. -> not empty */
            ret = 0;
            goto bailout;
        }
    } else {
        ret = -1; // this should not happen...
    }
    
 bailout:
    closedir(dir);
    return ret;
}

static int
browse_fd_folder_asp(int eid, webs_t wp UNUSED, int argc, char **argv)
{
    u_int i;
    char link[PATH_MAX + 60];
    char dirstr[PATH_MAX];

    ejSetResult(eid, "");
    if (argc == 1) {
        for (i = 0; i < sizeof(browsable); ++i) {
            snprintf(dirstr, sizeof(dirstr), "%s%s", PP_FA_ROOT, argv[0]);
            if (!strcmp(argv[0], browsable[i]) && !dir_is_empty(dirstr)) {
                /* argv[0] is a not empty dir -> create a link */
                snprintf(link, sizeof(link), generic_link,
                         browse_prefix, argv[0], "Browse");
                ejSetResult(eid, link);
            }
        }
    }

    return 0;
}

static void
print_fd_folder_recursive(webs_t wp, const char *parent, const char *folder)
{
    DIR *dir;
    struct dirent *entry;
    struct stat statbuf;
    char dirstr[PATH_MAX], entrystr[PATH_MAX], filestr[PATH_MAX], tmp[PATH_MAX];
    char link[PATH_MAX + 60];
    static char *browser_line = "<tr><td>%s</td><td align=right>%s</td><td>%s</td></tr>";
    
    assert(parent && *parent);
    assert(folder); // folder can be empty -> browse parent
    
    snprintf(dirstr, sizeof(dirstr), "%s/%s", parent, folder);
    if ((dir = opendir(dirstr)) != NULL) {
        while ((entry = readdir(dir)) != NULL) {
            snprintf(entrystr, sizeof(entrystr), "%s/%s", dirstr, entry->d_name);
            if (!strcmp(entry->d_name, "..")
		|| !strcmp(entry->d_name, ".")
		|| lstat(entrystr, &statbuf) != 0) {
                continue;
	    }
            if (*folder) {
                snprintf(filestr, sizeof(filestr), "%s/%s", folder, entry->d_name);
	    } else {
		snprintf(filestr, sizeof(filestr), "%s", entry->d_name);
	    }
            if (S_ISDIR(statbuf.st_mode) && !dir_is_empty(entrystr)) {
                /* filestr is a not empty dir -> resolve it */
                print_fd_folder_recursive(wp, parent, filestr);
                continue;
            }
            snprintf(link, sizeof(link), generic_link, remove_prefix, entrystr, "Remove");
            websWrite(wp, browser_line, filestr,
                      byte_to_string(pp_fa_du(entrystr), tmp, PATH_MAX), link);
        }
        closedir(dir);
    }
}

static int
print_fd_folder_asp(int eid UNUSED, webs_t wp, int argc, char **argv)
{
    char dirstr[PATH_MAX];
    u_int i;

    ejSetResult(eid, "");
    if (argc == 1) {
        dirstr[0] = '\0';
        /* once more, check if really really browsable */
        for (i = 0; i < sizeof(browsable); ++i)
            if (!strcmp(argv[0], browsable[i])) {
                snprintf(dirstr, sizeof(dirstr), "%s%s", PP_FA_ROOT, argv[0]);
	    }
        if (dirstr[0]) {
            print_fd_folder_recursive(wp, dirstr, "");
	}
    }

    return 0;
}

#else /* !FD_FOLDERS_BROWSABLE */

static int
browse_fd_folder_asp(int eid, webs_t wp UNUSED, int argc, char **argv)
{
    char lnk[PATH_MAX];
    u_int i;
    
    assert(sizeof(browsable) == sizeof(browse_page));
    ejSetResult(eid, "");
    
    if (argc == 1) {
        for (i = 0; i < sizeof(browsable); ++i) {
            if (!strcmp(argv[0], browsable[i])) {
                snprintf(lnk, sizeof(lnk), "<a href=\"%s\">settings</a>", 
                         browse_page[i]);
                ejSetResult(eid, lnk);
            }
        }
    }

    return 0;
}

static int
print_fd_folder_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    ejSetResult(eid, "");
    return 0;
}

#endif /* !FD_FOLDERS_BROWSABLE */

static char *
byte_to_string(long bytes, char *str, int length)
{
    double size = (double)bytes;
    u_int u_id = 0;
    static const char *unit[] = { "b", "kb", "Mb", "Gb", "Tb", "Pb" };

    while (size > 1000.0) {
        size /= 1024.0;
        ++u_id;
    }

    if (u_id < (sizeof(unit) / sizeof(*unit))) {
	snprintf(str, length, "%.2f</td><td>%s", size, unit[u_id]);
    } else {
	snprintf(str, length, "%.2f</td><td>", size);
    }

    return str;
}

