#include <pp/base.h>
#include <pp/firmware.h>
#include <pp/intl.h>
#ifdef PRODUCT_SMARTIPC
# include <pp/minicom.h>
#endif
// really needed? #include <lara.h>
#include "eric_base.h"
#include "eric_forms.h"
#include "eric_util.h"
#include "webs.h"
#include "wsIntrn.h"
#include "tmpl_firmware_common.h"
#if defined(PP_FEAT_RPCCFG)
# include <pp/rpc_ripc.h>
#endif

FV_SPEC = {
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
firmware_update_tmpl_init(void)
{
    form_handler_t * fh;

    if (firmware_common_tmpl_init() != 0) return -1;

    fh = CREATE_FH_INSTANCE(TEMPLATE_FIRMWARE_UPDATE, ACL_OBJ_FIRMWARE);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp,  form_handler_t * fh UNUSED)
{
    int r;
    int do_update  = form_button_clicked(wp, "action_firmware_update");
    int do_discard = form_button_clicked(wp, "action_firmware_discard");

#ifdef PRODUCT_SMARTIPC
    if (!strcmp(websGetVar(wp, "smartipc_osd_update", ""), "yes")) {
	pp_log("Update Smart IPC OSD.\n");
	if (pp_minicom_update_osd_defaults()) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("OSD not reset to default. OSD may not work anymore."));
	} else {
	    set_response(wp, ERIC_RESPONSE_OK, _("OSD reset to default successfully."));
	}
    }
#endif /* PRODUCT_SMARTIPC */

    if (do_discard) {
#ifdef PP_FEAT_RPCCFG
	/* we assume that we are master! */
	int clnt_res;
	if (PP_FAILED(pp_rpc_action(&clnt_res, PP_RPC_ACTION_FW_DISCARD, PP_RPC_TARGET_SLAVE))
	    && PP_FAILED(clnt_res)) {
	    pp_log("%s(): Discarding Firmware on Slave failed. Ignored.", ___F);
	}
#endif /* PP_FEAT_RPCCFG */
	set_response(wp, ERIC_RESPONSE_OK, _("Discarded the uploaded firmware."));
	eric_notify_post_event("Uploaded firmware file discarded.", "device", PP_NOTIFY_EVENT_GENERIC);
	pp_firmware_erla_ctx_free(wp->sd->firmware_ctx);
	wp->sd->firmware_ctx = 0;
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    } else if (do_update) {
#ifdef PP_FEAT_RPCCFG
	/* we assume that we are master! */
	/* start firmware update on slave */
	if (PP_SUCCED(pp_rpc_fw_update())) {
#endif /* PP_FEAT_RPCCFG */
	    if ((r = pp_firmware_erla_update(wp->sd->firmware_ctx)) == PP_SUC) {
	        char redirect[200];
	        int redirect_to;
	        pp_cfg_get_int(&redirect_to, "reset_redirect_time");
	        snprintf(redirect, sizeof(redirect),
	            "<meta http-equiv=\"refresh\" content=\"%d; URL=/\">",
	            60 * redirect_to);

		pp_firmware_erla_ctx_free(wp->sd->firmware_ctx);
		wp->sd->firmware_ctx = 0;
		websSetRequestPath(wp, wp->dir, "fwupdated.asp");
		set_response(wp, ERIC_RESPONSE_OK,
			     _("Firmware updated successfully.<br>"
			       "The device will be reset in a few seconds."));
		websSetVar(wp, "_show_redirect_info", "1");
		websSetVar(wp, "__meta__", redirect);

		/* NOTE: Reset is done asynchronously after some seconds. */
		device_reset(wp);
	    } else if (r == PP_FIRMWARE_ERR_CRIT) {
		websSetRequestPath(wp, wp->dir, "fwupdated.asp");
		set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(errno));
		websSetVar(wp, "_show_reset", "1");
	    } else { /* PP_FIRMWARE_ERR_NONCRIT */
		set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(errno));
	    }
#ifdef PP_FEAT_RPCCFG
	} else {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Internal: Firmware update failed."));
	}
#endif /* PP_FEAT_RPCCFG */
    }

    return 0;
}
