#include <pp/ipmi.h>
#include <pp/intl.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

#ifdef PP_FEAT_IPMI_CLIENT

FV_SPEC = {
    {
	id:		FV_ID_IPMI_MEDIUM,
	cfgkey:		"ipmi.medium._c_"
    },
    {
	id:		FV_ID_IPMI_MEDIUM_SERIAL_PASSWORD,
	cfgkey:		"ipmi.medium.serial.password"
    },
    {
	id:		FV_ID_IPMI_MEDIUM_LAN_IPADDR,
	cfgkey:		"ipmi.medium.lan.ipaddr"
    },
    {
	id:		FV_ID_IPMI_MEDIUM_LAN_USERNAME,
	cfgkey:		"ipmi.medium.lan.username"
    },
    {
	id:		FV_ID_IPMI_MEDIUM_LAN_PASSWORD,
	cfgkey:		"ipmi.medium.lan.password"
    },
    {
	id:		FV_ID_IPMI_MEDIUM_I2C_BMC_ADDRESS,
	cfgkey:		"ipmi.medium.i2c.bmc_address"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_save_hook(webs_t wp, form_handler_t * fh);

int
ipmi_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI, ACL_OBJ_IPMI);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_save_hook = post_save_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (!strcmp(fh->fv[FV_ID_IPMI_MEDIUM].val.s, "none")) {
	fh_disable_validate_and_save(fh, FV_ID_IPMI_MEDIUM);
    } else {
	if (strcmp(fh->fv[FV_ID_IPMI_MEDIUM].val.s, "serial")) {
	    fh->fv[FV_ID_IPMI_MEDIUM_SERIAL_PASSWORD].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	}
	if (strcmp(fh->fv[FV_ID_IPMI_MEDIUM].val.s, "lan")) {
	    fh->fv[FV_ID_IPMI_MEDIUM_LAN_IPADDR].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	    fh->fv[FV_ID_IPMI_MEDIUM_LAN_PASSWORD].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	}
    }

    return 0;
}

static int
post_save_hook(webs_t wp, form_handler_t * fh)
{
    int ipmi_disabled = !strcmp(fh->fv[FV_ID_IPMI_MEDIUM].val.s, "none");

    if (!ipmi_disabled) {
	pp_ipmi_return_t ipmi_ret;
	int error;
	memset(&ipmi_ret, 0, sizeof(ipmi_ret));
	
	int ipmi_state = pp_ipmi_send_command(PP_IPMI_CMD_BMC, PP_IPMI_BMC_SUBCMD_INFO, NULL, &ipmi_ret, &error, wp->user);
	
	pp_ipmi_cleanup_ret(&ipmi_ret);
	
	if (ipmi_state != 0) {
	    if (pp_ipmi_is_auth_failed(error)) {
	    	set_response(wp, ERIC_RESPONSE_ERROR, _("IPMI detected but authentication failed."));
	    } else {
	    	set_response(wp, ERIC_RESPONSE_ERROR, _("IPMI not detected."));
	    }
	    return -1;
	}
    }

    return 0;
}

#else /* !PP_FEAT_IPMI_CLIENT */

int ipmi_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_IPMI_CLIENT */
