#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

FV_SPEC = {
    {
        id:             FV_ID_IPMI_CHASSIS_LOCATOR,
        cfgkey:         "ipmi.chassis.locator_duration"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int ipmi_chassis_locator(webs_t wp, const char * command);

int ipmi_chassis_locator_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_CHASSIS_LOCATOR, ACL_OBJ_IPMI_STATUS);
    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

/* the formular handler (parses the buttons) */
static int pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    if (form_button_clicked(wp, "action_identify")) {
        pp_log("Activating Chassis Locator.\n");
        if (ipmi_chassis_locator(wp,
                                 fh->fv[FV_ID_IPMI_CHASSIS_LOCATOR].val.s)) {
            set_response(wp, ERIC_RESPONSE_ERROR, _("Could not activate Chassis Locator!"));
        } else {
            set_response(wp, ERIC_RESPONSE_OK, _("Successfully activated Chassis Locator."));
        }
    }

    return 0;
}

/* backend for the buttons */
static int ipmi_chassis_locator(webs_t wp, const char * command) {
    int ret = 0;
    pp_ipmi_parameter_t ipmi_param;

    memset(&ipmi_param, 0, sizeof(ipmi_param));

    pp_log("Setting Chassis Locator to %s\n", command);

    if (!strcmp(command, "off")) {
        ipmi_param.data.chassis_identify = 0;
    } else if (!strcmp(command, "on")) {
        ipmi_param.data.chassis_identify = -1;
    } else if (!strcmp(command, "15")) {
        ipmi_param.data.chassis_identify = 15;
    } else if (!strcmp(command, "60")) {
        ipmi_param.data.chassis_identify = 60;
    } else {
        pp_log("Unknown Chassis Locator command.\n");
        ret = -1;
    }

    if (!ret) {
        pp_ipmi_return_t ipmi_ret;
        memset(&ipmi_ret, 0, sizeof(ipmi_ret));
        ret = pp_ipmi_send_command(PP_IPMI_CMD_CHASSIS, PP_IPMI_CHASSIS_SUBCMD_IDENTIFY, &ipmi_param, &ipmi_ret, NULL, wp->user);
        pp_ipmi_cleanup_ret(&ipmi_ret);
    }

    if (ret) {
        pp_log("Error in sending Chassis Locator command.\n");
    }

    return ret;
}
