#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include "tmpl_ipmi_common.h"

/**
 * Some common functions used by all ipmi alert pages (ipmi_xxx_list
 * and ipmi_xxx_edit), mainly functions for building tables and forms
 * in the C-Code.
 */

void print_head(pp_strstream_t* tab, const unsigned char* str) {
    unsigned char buf[200];
#if !defined(PP_FEAT_RARITAN_DESIGN)
    snprintf(buf, sizeof(buf), "<td class=\"bold\">%s</td>\n", str);
#else
    snprintf(buf, sizeof(buf), "<td class=\"settings_fieldname\">%s\n", str);
#endif    
    pp_strappend(tab, buf);
}

void __print_cell(pp_strstream_t* tab, const unsigned char* format, const void* value) {
    unsigned char form[150];
    unsigned char buf[250];
#if !defined(PP_FEAT_RARITAN_DESIGN)
    snprintf(form, sizeof(form), "<td class = \"normal\" align=right><tt>%s</tt></td>\n", format);
#else
    snprintf(form, sizeof(form), "'%s',", format);
#endif
    snprintf(buf, sizeof(buf), form, value);
    pp_strappend(tab, buf);
}

void print_fv(pp_strstream_t* tab, int fv_name, const char* template_name) {
    unsigned char buf[100];
    snprintf(buf, sizeof(buf), "name=\"FV_%d_%s\"", fv_name, template_name);
    pp_strappend(tab, buf);
}

void __print_input(pp_strstream_t* tab, int name, const char* template_name, const char* type,
                          const char* format, void* value, int size, int readonly)
{
    unsigned char form[200];
    unsigned char buf[250];
    const char* bufp;
    if (readonly == 0) {
        bufp = "";
    } else {
        bufp = "readonly";
    }
    
    if (strcmp(format, "%.2x") == 0) {
        pp_strappend(tab, "&nbsp;0x");
    }
    snprintf(form, sizeof(form),
             "<input name=\"FV_%d_%s\" type=\"%s\" value=\"%s\" size=\"%d\" maxlength=\"%d\" %s>",
             name, template_name, type, format, size, size, bufp);
    snprintf(buf, sizeof(buf), form, value);
    pp_strappend(tab, buf);
}

void __print_input_cell(pp_strstream_t* tab, int name, const char* template_name, const char* type,
                          const char* format, void* value, int size, int readonly)
{
#if !defined(PP_FEAT_RARITAN_DESIGN)
     pp_strappend(tab, "<td class = \"normal\" align=right>");
#else
     pp_strappend(tab, "<br>");
#endif
     __print_input(tab, name, template_name, type, format, value, size, readonly);
     pp_strappend(tab, "</td>\n");
}

