#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "tmpl_ipmi_common.h"

/* internal prototypes */
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static void display_policy_table(pp_strstream_t* tab, webs_t wp);
static void add_policy_table_head(pp_strstream_t *tab);
static void add_policy_table_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol, int pol_edit_no);
static void add_policy_table_list_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol, int pol_edit);
static int ipmi_build_policy_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED);


#define PP_LAN_CHANNEL  1

FV_SPEC = {
};


int ipmi_policy_list_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiGetPolicyList", ipmi_build_policy_table_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_POLICY_LIST, ACL_OBJ_IPMI_STATUS);
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}


static int post_validate_hook(webs_t wp, form_handler_t * fh)
{
    //pp_ipmi_pef_policy_t* pol;
    //pp_ipmi_parameter_t in_parm;
    (void)wp;
    (void)fh;

    return 0;
}

static void display_policy_table(pp_strstream_t* tab, webs_t wp) {
    vector_t* policies;
    unsigned int i;
    pp_ipmi_return_t ipmi_ret;
    const char* polNoStr;
    int polNo;
    int err;
    
    /* check if one entry can be edited */
    polNoStr = websGetVar(wp, "pol", "no_id");
    polNo = pp_strtoul_10(polNoStr, 0, &err);
    if (err) {
        polNo = -1;
    }
    
    /* read values from ipmi */
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    if (!pp_ipmi_send_command(PP_IPMI_CMD_PEF, PP_IPMI_PEF_POLICY_GET, NULL, &ipmi_ret, NULL, wp->user)) {
        policies = ipmi_ret.data.pef_policy_list;
    } else {
        policies = NULL;
    }
    
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<table border=\"1\">\n");
#else
    pp_strappend(tab, "<script>\n");    
#endif
    add_policy_table_head(tab);
    if (policies != NULL) {
        for (i=0; i<vector_size(policies); i++) {
            add_policy_table_entry(tab, (pp_ipmi_pef_policy_t*)vector_get(policies, i), polNo);
        }
    } else {
#if !defined(PP_FEAT_RARITAN_DESIGN)    
	pp_strappend(tab, "<tr><td colspan=7>");
	pp_strappend(tab, _("Error reading the PEF policies"));
	pp_strappend(tab, "</td></tr>\n");
#else
        pp_strappend(tab, "table_entry('");
	pp_strappend(tab, _("Error reading the PEF policies"));
    pp_strappend(tab, "','','','','','','','');</script>\n");
#endif	
    }
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "</table>\n");
#else
    pp_strappend(tab, "\n</script>\n");    
#endif    
    vector_delete(policies);
}

static void add_policy_table_head(pp_strstream_t *tab) {
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<tr>\n");
    pp_strappend(tab, "  <td class=\"bold\">Index</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Status</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Policy Set</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Policy</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Channel No.</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Destination</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Alert String</td>\n");
    pp_strappend(tab, "</tr>\n");
#else /* PP_FEAT_RARITAN_DESIGN */
    (void)tab;
#endif /* PP_FEAT_RARITAN_DESIGN */
}

static void add_policy_table_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol, int pol_edit_no) {
    if (pol_edit_no == -1) {
        add_policy_table_list_entry(tab, pol, 1);
    } else {
        if (pol_edit_no != pol->id) {
            add_policy_table_list_entry(tab, pol, 0);
        }
    }
}
   
static void add_policy_table_list_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol, int show_edit) {
    const unsigned char* bufp;
    assert(tab);
    assert(pol);
#if !defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "<tr>\n");
#else
    pp_strappend(tab, "\n table_entry(");
#endif    

    print_cell(tab, "%d", pol->id);

    if (pol->enable == 1) {
        bufp = "enabled";
    } else {
        bufp = "disabled";
    }
    print_cell(tab, "%s", bufp);
    
    print_cell(tab, "%d", pol->number);
    
    bufp = "unknown";
    switch(pol->policy) {
        case 0x00:
            bufp = "always";
            break;
        case 0x01:
            bufp = "skip this destination";
            break;
        case 0x02:
            bufp = "stop alerting";
            break;
        case 0x03:
            bufp = "proceed on next channel";
            break;
        case 0x04:
            bufp = "proceed with next destination type";
    }
    print_cell(tab, "%s", bufp);
    
    if (pol->channel == PP_LAN_CHANNEL) {
        bufp = "LAN (%d)";
    } else {
        bufp = "%d";
    }
    print_cell(tab, bufp, pol->channel);

    print_cell(tab, "%d", pol->destination);

    print_cell(tab, "%d", pol->alert_string);
    
#if !defined(PP_FEAT_RARITAN_DESIGN)        
    if (show_edit == 1) {
	print_cell(tab, "<a href=\"ipmi_policy_edit.asp?pol=%d\">[edit]</a>", pol->id);
    } else {
	print_cell(tab, " ", pol->id);
    }
    pp_strappend(tab, "</tr>\n");
#else
    if (show_edit == 1) {
        print_cell(tab, "<a href=\"ipmi_policy_edit.asp?pol=%d\">[edit]</a>'); //", pol->id);
    } else {
        print_cell(tab, "'); //", pol->id);
    }
#endif    
}

static int ipmi_build_policy_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_strstream_t tab = PP_STRSTREAM_INITIALIZER;

    pp_strstream_init(&tab);

    display_policy_table(&tab, wp);

    ejSetResult(eid, tab.buf ? tab.buf : "");

    pp_strstream_free(&tab);

    return 0;
}

