#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#ifdef PP_FEAT_IPMI_CLIENT_SENSORS

static const char * error_msg = N_("An error occured while reading the SDR-repository! Maybe someone else is trying to access the SDR.");
static const char * sdr_not_supported_msg = N_("Sensor Data Records are not available on the connected host!");

FV_SPEC = {
};

static int ipmi_get_sensor_data_asp(int eid, webs_t wp, int argc, char ** argv);

int
ipmi_status_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiGetSensorData", ipmi_get_sensor_data_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_STATUS, ACL_OBJ_IPMI_STATUS);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
ipmi_get_sensor_data_asp(int eid UNUSED, webs_t wp, int argc UNUSED,
			 char ** argv UNUSED)
{
    char opt_name[MAX_OPT_KEY_LEN + 1];
    char val[18];
    int i;
    int prec;
    const char * status;
    const char * opt_name_prefix;
    int * count_p;
    int fan_count = 0;
    int temp_count = 0;
    int voltage_count = 0;
    int error = 0;
    int host_has_power = 1;

    pp_ipmi_return_t ipmi_ret;
    pp_strstream_t sensor_table = PP_STRSTREAM_INITIALIZER;
    int no_sensors = 0;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));

    if (!pp_ipmi_send_command(PP_IPMI_CMD_CHASSIS, PP_IPMI_CHASSIS_SUBCMD_POWER_STATUS, NULL, &ipmi_ret, &error, wp->user)) {
    	if (ipmi_ret.data.chassis_power_status.status == PP_IPMI_CHASSIS_POWER_STATUS_OFF) {
    	    host_has_power = 0;
    	}
    }

    pp_ipmi_cleanup_ret(&ipmi_ret);
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    pp_strstream_init(&sensor_table);

    if (!pp_ipmi_send_command(PP_IPMI_CMD_SDR, PP_IPMI_SDR_SUBCMD_LIST, NULL, &ipmi_ret, &error, wp->user)) {
    	no_sensors = vector_size(ipmi_ret.data.sdr_list);
    	
    	pp_log("found %d SDR entries.\n", no_sensors);
    	
    	if (no_sensors > 0) {
    	    for (i = 0; i < no_sensors; i++) {
    	    	pp_ipmi_sdr_list_entry_t *entry = vector_get(ipmi_ret.data.sdr_list, i);
    	    	
    	    	if (!entry || entry->type != PP_IPMI_SENSOR_TYPE_FULL) {
    	    	    continue;
    	    	}
    	    	
    	    	switch (entry->spec_type) {
    	    	    case PP_IPMI_SPEC_SENSOR_TYPE_FAN:
			count_p = &fan_count;
			opt_name_prefix = "fan";
			prec = 0;
			break;
    	    	    case PP_IPMI_SPEC_SENSOR_TYPE_VOLTAGE:
			count_p = &voltage_count;
			opt_name_prefix = "voltage";
			prec = 2;
			break;
    	    	    case PP_IPMI_SPEC_SENSOR_TYPE_TEMPERATURE:
			count_p = &temp_count;
			opt_name_prefix = "temp";
			prec = 1;
			break;
		    default:
		    	continue;
    	    	}
    	    	
    	    	if (host_has_power) {
    	    	    switch (entry->data.full.status) {
    	    	    	case PP_IPMI_SENSOR_STATUS_NO_READING:
    	    	    	    status = "NO READING";
    	    	    	    break;
    	    	    	case PP_IPMI_SENSOR_STATUS_OK:
    	    	    	    status = "OK";
    	    	    	    break;
    	    	    	case PP_IPMI_SENSOR_STATUS_LOWER_NON_CRITICAL:
    	    	    	case PP_IPMI_SENSOR_STATUS_UPPER_NON_CRITICAL:
    	    	    	    status = "WARNING";
    	    	    	    break;
    	    	    	case PP_IPMI_SENSOR_STATUS_LOWER_CRITICAL:
    	    	    	case PP_IPMI_SENSOR_STATUS_UPPER_CRITICAL:
    	    	    	    status = "CRITICAL";
    	    	    	    break;
    	    	    	case PP_IPMI_SENSOR_STATUS_LOWER_NON_RECOVERABLE:
    	    	    	case PP_IPMI_SENSOR_STATUS_UPPER_NON_RECOVERABLE:
    	    	    	    status = "FAILURE";
    	    	    	    break;
    	    	    	default:
    	    	    	    status = "UNKNOWN";
    	    	    }
    	    	} else {
    	    	    status = "NO POWER";
    	    	}
    	    	
	    	snprintf(opt_name, sizeof(opt_name), "%s_id_%u",
		     opt_name_prefix, *count_p);
	    	snprintf(val, sizeof(val), "%u", entry->sdr_id);
	    	websSetVar(wp, opt_name, val);
	    	
	    	snprintf(opt_name, sizeof(opt_name), "%s_owner_%u",
		     opt_name_prefix, *count_p);
	    	snprintf(val, sizeof(val), "%u", entry->data.full.owner_id);
	    	websSetVar(wp, opt_name, val);
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_name%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	websSetVar(wp, opt_name, entry->sdr_name.buf ? : "Unknown");
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_status%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	websSetVar(wp, opt_name, status);
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_value%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	if (entry->data.full.reading.valid) {
	    	    snprintf(val, sizeof(val), "%.*f", prec, entry->data.full.reading.value);
	    	} else {
	    	    snprintf(val, sizeof(val), "n/a");
	    	}
	    	websSetVar(wp, opt_name, val);
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_min_crit%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	if (entry->data.full.lower_critical.valid) {
	    	    snprintf(val, sizeof(val), "%.*f", prec, entry->data.full.lower_critical.value);
	    	} else {
	    	    snprintf(val, sizeof(val), "n/a");
	    	}
	    	websSetVar(wp, opt_name, val);
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_min%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	if (entry->data.full.lower_non_critical.valid) {
	    	    snprintf(val, sizeof(val), "%.*f", prec, entry->data.full.lower_non_critical.value);
	    	} else {
	    	    snprintf(val, sizeof(val), "n/a");
	    	}
	    	websSetVar(wp, opt_name, val);
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_max%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	if (entry->data.full.upper_critical.valid) {
	    	    snprintf(val, sizeof(val), "%.*f", prec, entry->data.full.upper_critical.value);
	    	} else {
	    	    snprintf(val, sizeof(val), "n/a");
	    	}
	    	websSetVar(wp, opt_name, val);
	    
	    	snprintf(opt_name, sizeof(opt_name), "%s_max_crit%c%u",
		     opt_name_prefix, fv_vec_idx_deli, *count_p);
	    	if (entry->data.full.upper_non_critical.valid) {
	    	    snprintf(val, sizeof(val), "%.*f", prec, entry->data.full.upper_non_critical.value);
	    	} else {
	    	    snprintf(val, sizeof(val), "n/a");
	    	}
	    	websSetVar(wp, opt_name, val);
	    	
	    	(*count_p)++;
    	    }
    	} else {
    	    pp_log("No sensors found.\n");
    	}
    } else if ( error == 0xC1 ) { 
	pp_log("Error detected C1\n");
	set_response(wp, ERIC_RESPONSE_ERROR, sdr_not_supported_msg); 
    } else {
	pp_log("Error detected -1\n");
	set_response(wp, ERIC_RESPONSE_ERROR, error_msg); 
    }
    
    pp_ipmi_cleanup_ret(&ipmi_ret);

    snprintf(val, sizeof(val), "%u", fan_count);
    websSetVar(wp, "fan_id_cnt", val);
    snprintf(val, sizeof(val), "%u", temp_count);
    websSetVar(wp, "temp_id_cnt", val);
    snprintf(val, sizeof(val), "%u", voltage_count);
    websSetVar(wp, "voltage_id_cnt", val);
    return 0;
}

#else /* !PP_FEAT_IPMI_CLIENT_SENSORS */

int ipmi_status_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_IPMI_CLIENT_SENSORS */
