#include <liberic_notify.h>
#include <pp/intl.h>
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_util.h"

FV_SPEC = {
    {
	id:		FV_ID_LOG_LIST_ENABLED,
	cfgkey:		"log.list.enabled"
    },
    {
	id:		FV_ID_LOG_LIST_ENTRIES_SHOWN,
	cfgkey:		"log.list.entries_shown"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
log_list_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_LOG_LIST, ACL_OBJ_LOG_S);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    if (form_button_clicked(wp, "action_log_clear")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Clear' if you really want to clear the event log!"));
	websSetVar(wp, "_show_log_clear_confirm", "1");
    } else if (form_button_clicked(wp, "action_really_log_clear")) {
	char logmsg[PP_NOTIFY_MAX_MSG_LEN+1];
        snprintf(logmsg, sizeof(logmsg), _("Internal log file cleared by user '%s'."), wp->user);
        eric_notify_list_log_clear();
        eric_notify_post_event(logmsg, "device", PP_NOTIFY_EVENT_GENERIC);
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	set_response(wp, ERIC_RESPONSE_OK, _("Internal log file cleared."));
    } else if (form_button_clicked(wp, "action_cancel_log_clear")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	set_response(wp, ERIC_RESPONSE_OK, _("Clear log operation cancelled."));
    } else {
	if (strcmp(fh->fv[FV_ID_LOG_LIST_ENABLED].val.s, "yes")) {
	    fh_disable_validate_and_save(fh, FV_ID_LOG_LIST_ENABLED);
	}
    }
    return 0;
}
