#include <liberic_notify.h>
#include <pp/cfg.h>
#include "eric_validate.h"
#include "eric_util.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_LOG_NFS_ENABLED,
	cfgkey:		"log.nfs.enabled"
    },
    {
	id:		FV_ID_LOG_NFS_LOG_SERVER,
	cfgkey:		"log.nfs.server"
    },
    {
	id:		FV_ID_LOG_NFS_LOG_SHARE,
	cfgkey:		"log.nfs.share"
    },
    {
	id:		FV_ID_LOG_NFS_LOG_FILE,
	cfgkey:		"log.nfs.file"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
log_nfs_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_LOG_NFS, ACL_OBJ_LOG_S);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (strcmp(fh->fv[FV_ID_LOG_NFS_ENABLED].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_LOG_NFS_ENABLED);
    }
    
    return 0;
}

