#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_OEM_DEVEL_ACTIVE,
	cfgkey:		"oem.devel.active",
    },
    {
	id:		FV_ID_OEM_DEVEL_HOST,
	cfgkey:		"oem.devel.host",
    },
    {
	id:		FV_ID_OEM_DEVEL_SHARE,
	cfgkey:		"oem.devel.share",
    },
    {
	id:		FV_ID_OEM_DEVEL_USER,
	cfgkey:		"oem.devel.user",
    },
    {
	id:		FV_ID_OEM_DEVEL_PASS,
	cfgkey:		"oem.devel.pass",
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
oem_dev_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_OEM_DEV, ACL_OBJ_OEM);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED,  form_handler_t * fh)
{
    if (strcmp(fh->fv[FV_ID_OEM_DEVEL_ACTIVE].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_OEM_DEVEL_ACTIVE);
    }
    /* clear passwd if no user is given (anonymous login) */
    if (*fh->fv[FV_ID_OEM_DEVEL_USER].val.s == '\0') {
        fh->fv[FV_ID_OEM_DEVEL_PASS].flags &= ~FV_FLAG_DONT_SAVE;
    }
    return 0;
}

