#include <pp/cfg.h>
#include <pp/intl.h>
#include <pp/powerswitch.h>
#include <liberic_notify.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_POWER_CTRL_ENABLE

FV_SPEC = {
    {
	id:		FV_ID_PS_PSU_ADAPT_ENABLED,
	cfgkey:		"ps.psu_adapt_enabled"
    },    
    {
	id:		FV_ID_PS_ATX_ENABLED,
	cfgkey:		"ps.atx_enabled"
    },
    {
	id:		FV_ID_PS_SERIAL1,
	cfgkey:		"ps.serial[0]._c_"
    },
    {
	id:		FV_ID_PS_SERIAL2,
	cfgkey:		"ps.serial[1]._c_"
    },

    /* ---- SENTRY (serial 1) ---------------------------------------------- */

    {
	id:		FV_ID_PS_SENTRY_USER_SERIAL1,
	cfgkey:		"ps.serial[0].sentry.user"
    },
    {
	id:		FV_ID_PS_SENTRY_PASS_SERIAL1,
	cfgkey:		"ps.serial[0].sentry.pass"
    },
    {
	id:		FV_ID_PS_SENTRY_LSPEED_SERIAL1,
	cfgkey:		"ps.serial[0].sentry.speed"
    },

    /* ---- SENTRY (serial 2) ---------------------------------------------- */

    {
	id:		FV_ID_PS_SENTRY_USER_SERIAL2,
	cfgkey:		"ps.serial[1].sentry.user"
    },
    {
	id:		FV_ID_PS_SENTRY_PASS_SERIAL2,
	cfgkey:		"ps.serial[1].sentry.pass"
    },
    {
	id:		FV_ID_PS_SENTRY_LSPEED_SERIAL2,
	cfgkey:		"ps.serial[1].sentry.speed"
    },

    /* ---- SPC (serial 1) ------------------------------------------------- */

    {
	id:		FV_ID_PS_SPC_USER_SERIAL1,
	cfgkey:		"ps.serial[0].spc.user"
    },
    {
	id:		FV_ID_PS_SPC_PASS_SERIAL1,
	cfgkey:		"ps.serial[0].spc.pass"
    },

    /* ---- SPC (serial 2) ------------------------------------------------- */

    {
	id:		FV_ID_PS_SPC_USER_SERIAL2,
	cfgkey:		"ps.serial[1].spc.user"
    },
    {
	id:		FV_ID_PS_SPC_PASS_SERIAL2,
	cfgkey:		"ps.serial[1].spc.pass"
    },

    /* ---- SMART (serial 1) ----------------------------------------------- */

    {
	id:		FV_ID_PS_SMART_DEV_ADDR_SERIAL1,
	cfgkey:		"ps.serial[0].smart[%I]",
	elemkey:        "dev_addr"
    },
    {
	id:		FV_ID_PS_SMART_DEV_TYPE_SERIAL1,
	cfgkey:		"ps.serial[0].smart[%I]",
	elemkey:        "dev_type"
    },

    /* ---- SMART (serial 2) ----------------------------------------------- */
    
    {
	id:		FV_ID_PS_SMART_DEV_ADDR_SERIAL2,
	cfgkey:		"ps.serial[1].smart[%I]",
	elemkey:        "dev_addr"
    },
    {
	id:		FV_ID_PS_SMART_DEV_TYPE_SERIAL2,
	cfgkey:		"ps.serial[1].smart[%I]",
	elemkey:        "dev_type"
    },

     /* ---- TangTop IP Power (serial 1) ----------------------------------- */

    {
	id:		FV_ID_PS_IPWR_DEV_ADDR_SERIAL1,
	cfgkey:		"ps.serial[0].ipwr[%I]",
	elemkey:        "dev_addr"
    },

    /* ---- TangTop IP Power (serial 2) ------------------------------------ */

    {
	id:		FV_ID_PS_IPWR_DEV_ADDR_SERIAL2,
	cfgkey:		"ps.serial[1].ipwr[%I]",
	elemkey:        "dev_addr"
    },

    /* ---- FJSMS (serial 1) ----------------------------------------------- */

    {
	id:		FV_ID_PS_FJSMS_USER_SERIAL1,
	cfgkey:		"ps.serial[0].fjsms.user"
    },
    {
	id:		FV_ID_PS_FJSMS_PASS_SERIAL1,
	cfgkey:		"ps.serial[0].fjsms.pass"
    },
    {
	id:		FV_ID_PS_FJSMS_LSPEED_SERIAL1,
	cfgkey:		"ps.serial[0].fjsms.speed"
    },

    /* ---- FJSMS (serial 2) ----------------------------------------------- */

    {
	id:		FV_ID_PS_FJSMS_USER_SERIAL2,
	cfgkey:		"ps.serial[1].fjsms.user"
    },
    {
	id:		FV_ID_PS_FJSMS_PASS_SERIAL2,
	cfgkey:		"ps.serial[1].fjsms.pass"
    },
    {
	id:		FV_ID_PS_FJSMS_LSPEED_SERIAL2,
	cfgkey:		"ps.serial[1].fjsms.speed"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int smart_serial1_is_entry_empty(form_var_t * form_vars, u_int idx);
static int smart_serial2_is_entry_empty(form_var_t * form_vars, u_int idx);
static int set_device_vars_asp(int eid, webs_t wp, int argc, char ** argv);

int
power_switch_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("setDeviceVars", set_device_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_POWER_SWITCH, ACL_OBJ_POWER_SWITCH);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    /* ------------------------------------------------------------------------
     * Check if the user wants more entries. Give him more if maximum
     * is not reached yet.
     */
    int more_entries_smart_1 = form_button_clicked(wp, "action_more_entries_smart_serial1");
    int more_entries_smart_2 = form_button_clicked(wp, "action_more_entries_smart_serial2");
    int lookup_entries_1 = form_button_clicked(wp, "action_lookup_entries_serial1");
    int lookup_entries_2 = form_button_clicked(wp, "action_lookup_entries_serial2");

    if (more_entries_smart_1 || more_entries_smart_2) {
        form_var_t * fv = NULL;
        if (more_entries_smart_1) {
            fv = &fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL1];
        } else if (more_entries_smart_2) {
            fv = &fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL2];
	} else {
            assert(0);
        }
        fv->val_cnt = form_var_vec_increase(wp, fv->fvname, fv->val_cnt,
					    4, fv->val_cnt_max, "");
        wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	return 0;
    } else if (lookup_entries_1) {
	pp_power_login(PP_POWER_PORT_ID_SERIAL_1);
	pp_power_lookup_devices(PP_POWER_PORT_ID_SERIAL_1);
	pp_power_logout(PP_POWER_PORT_ID_SERIAL_1);
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    } else if (lookup_entries_2) {
	pp_power_login(PP_POWER_PORT_ID_SERIAL_2);
	pp_power_lookup_devices(PP_POWER_PORT_ID_SERIAL_2);
	pp_power_logout(PP_POWER_PORT_ID_SERIAL_2);
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    } else if (form_button_clicked(wp, "action_apply")) {
#define NUM_IDS_SMART 2
	int ids_smart_1[NUM_IDS_SMART] = { FV_ID_PS_SMART_DEV_ADDR_SERIAL1, FV_ID_PS_SMART_DEV_TYPE_SERIAL1 };
	int ids_smart_2[NUM_IDS_SMART] = { FV_ID_PS_SMART_DEV_ADDR_SERIAL2, FV_ID_PS_SMART_DEV_TYPE_SERIAL2 };

        /* ---------------------------------------------------------------------
         * remove empty entries
         */
        if (remove_entries(wp, fh->fv, 
                           fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL1].val_cnt,
                           ids_smart_1, NUM_IDS_SMART, smart_serial1_is_entry_empty) == -1) {
            return -1;
        }
        if (remove_entries(wp, fh->fv, 
                           fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL2].val_cnt,
                           ids_smart_2, NUM_IDS_SMART, smart_serial2_is_entry_empty) == -1) {
            return -1;
        }
    }
    return 0;
}

static int
post_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    char fvkey[FV_KEY_MAX_LEN+1];
    int i;

    /* ------------------------------------------------------------------------
     * The not so smart SMART switch: It doesn't work with lower case chars.
     */
    for (i = 0; i < fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL1].val_cnt; i++) {
	form_var_vec_name(fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL1].fvname, i,
			  fvkey, sizeof(fvkey));
	websTransCaseVar(wp, fvkey, CASE_UP);
    }
    for (i = 0; i < fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL2].val_cnt; i++) {
	form_var_vec_name(fh->fv[FV_ID_PS_SMART_DEV_ADDR_SERIAL2].fvname, i,
			  fvkey, sizeof(fvkey));
	websTransCaseVar(wp, fvkey, CASE_UP);
    }

    return 0;
}

static int
smart_serial1_is_entry_empty(form_var_t * form_vars, u_int idx)
{
    return (form_vars[FV_ID_PS_SMART_DEV_ADDR_SERIAL1].val.m[idx][0] == '\0');
}

static int
smart_serial2_is_entry_empty(form_var_t * form_vars, u_int idx)
{
    return (form_vars[FV_ID_PS_SMART_DEV_ADDR_SERIAL2].val.m[idx][0] == '\0');
}

/* FIXME: FIXME: This is a HACK - we must do this more generic (rwa) */
static int
set_device_vars_asp(int eid, webs_t wp UNUSED, int argc, char ** argv)
{
    if (argc == 1) {
	if ( !strcmp(argv[0], "ipwr") ) {
	    //int serial_1_open,
	    int dev_cnt, i;
	    char var_tmp[32];
	    char *var_value;
	    
	    if (PP_FAILED(pp_power_login(PP_POWER_PORT_ID_SERIAL_1))) {
		ejSetResult(eid, _("Opening Power Switch failed"));
		pp_log("%s(): Opening Power Switch failed",___F);
		return 0;
	    }
    
	    dev_cnt = pp_power_get_count(0, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_1);

	    snprintf(var_tmp, sizeof(var_tmp), "%d", dev_cnt);
	    websSetVar(wp, "_ps_ipwr_dev_cnt", var_tmp);
	    for ( i = 0; i < dev_cnt; i++ ) {
		var_value = pp_power_get_name(0, i, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_1);
		form_var_vec_name("_ps_ipwr_dev_name", i, var_tmp, sizeof(var_tmp));		
		websSetVar(wp, var_tmp, var_value);
		free(var_value);
		var_value = pp_power_get_name(0, i, PWR_OBJ_DEVICE_ADDR, PP_POWER_PORT_ID_SERIAL_1);
		form_var_vec_name("_ps_ipwr_dev_addr", i, var_tmp, sizeof(var_tmp));
		websSetVar(wp, var_tmp, var_value);
		free(var_value);
	    }
	    pp_power_logout(PP_POWER_PORT_ID_SERIAL_1);
	} else {
	    pp_log("Device detection is only available for IP-Power devices\n");
	}
    }
    return 0;
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int power_switch_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
