#include <pp/intl.h>
#include <liberic_misc.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_RC_HOTKEY,
	cfgkey:		"user[%U].rc.hotkey[%I]",
	elemkey:        "key"
    },
    {
	id:		FV_ID_RC_HOTKEYCODE,
	cfgkey:		"user[%U].rc.hotkey[%I]",
	elemkey:        "code"
    },
    {
	id:		FV_ID_RC_HOTKEYNAME,
	cfgkey:		"user[%U].rc.hotkey[%I]",
	elemkey:        "name"
    }   
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int is_entry_empty(form_var_t * form_vars, u_int idx);

int
rc_hotkeys_tmpl_init(void)
{
    form_handler_t * fh;
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_RC_HOTKEYS, ACL_OBJ_RC_HOTKEYS);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;
    fh->disable_ldap=TRUE;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
#define NUM_IDS 3
    int ids[NUM_IDS] = { FV_ID_RC_HOTKEY, FV_ID_RC_HOTKEYCODE, FV_ID_RC_HOTKEYNAME };

    /* ------------------------------------------------------------------------
     * Check if the user wants more entries. Give him more if maximum
     * is not reached yet.
     */
    if (form_button_clicked(wp, "action_more_hotkeys")) {
	form_var_t * fv = &fh->fv[FV_ID_RC_HOTKEY];
	fv->val_cnt = form_var_vec_increase(wp, fv->fvname, fv->val_cnt,
					    4, fv->val_cnt_max, "");
	
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    } else if (form_button_clicked(wp, "action_apply")) {
	/* ------------------------------------------------------------------------
	 * remove empty entries
	 */
	if (remove_entries(wp, fh->fv, fh->fv[FV_ID_RC_HOTKEY].val_cnt,
			   ids, NUM_IDS, is_entry_empty) == -1) {
	    return -1;
	}
    } else {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }

    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    int i;
    form_var_t * fv_hk = &fh->fv[FV_ID_RC_HOTKEY];
    form_var_t * fv_hkc = &fh->fv[FV_ID_RC_HOTKEYCODE];

    if (fv_hk->val_cnt != fv_hkc->val_cnt) {
	set_response(wp, ERIC_RESPONSE_ERROR, _("Internal error."));
	return -1;
    }

    for (i = 0; i < fv_hk->val_cnt; ++i) {
	char label[MAX_LABEL_LEN + 1];
	char hkc_var_name[FV_KEY_MAX_LEN+1];
	char * hkc_var_val;
	
	snprintf(label, sizeof(label), fv_hk->label, i + 1);
	if (translate_hotkey(wp, fv_hk->val.m[i], &hkc_var_val,
			     NULL, label, KEYPARSER_WITH_DELIS) < 0) {
 	    return -1;
	}
	form_var_vec_name(fv_hkc->fvname, i, hkc_var_name, sizeof(hkc_var_name));
	websSetVar(wp, hkc_var_name, hkc_var_val);
	fv_hkc->val.m[i] = websGetVar(wp, hkc_var_name, "");
	free(hkc_var_val);
    }

    return 0;
}

static int
is_entry_empty(form_var_t * form_vars, u_int idx)
{
    return (form_vars[FV_ID_RC_HOTKEY].val.m[idx][0] == '\0');
}
