#include <pp/um.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_RC_MONITOR_MODE_ENABLED,
	cfgkey:		"user[%U].rc.monitor_mode_enabled"
    },
    {
        /* no permission management, use explicit configuration option to allow exclusive access(rc_s_excl) */
	id:		FV_ID_RC_EXCL_ACCESS_ALLOWED,
	cfgkey:		"user[%U].rc.excl_access_allowed"
    },
    {
	id:		FV_ID_RC_EXCL_ACCESS_ENABLED,
	cfgkey:		"user[%U].rc.excl_access_enabled",
    },
    {
	id:		FV_ID_RC_FORENSIC_ENABLED,
	cfgkey:		"user[%U].rc.forensic_enabled",
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int rc_misc_set_vars_asp(int eid, webs_t wp, int argc, char ** argv);

int
rc_misc_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("rcMiscSetVars", rc_misc_set_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_RC_MISC, ACL_OBJ_ANYONE);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;
    fh->disable_ldap=TRUE;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (!form_button_clicked(wp, "action_apply")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }
    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
#if !defined(PP_FEAT_PERM_MANAGEMENT) && defined(PP_FEAT_RC_EXCLUSIVE_MODE) && defined(PP_FEAT_RC_ALLOW_CHANGING_EXCLUSIVE_PERM)
    /* no permission management, use explicit configuration option to allow exclusive access(rc_s_excl) */
    vector_t* perms = NULL;
    int isroot, excl_access_allowed;
    u_int i, perms_sz;

    if (!form_button_clicked(wp, "action_apply")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }

    /* we need to differentiate "no" and "not set" for excl_allowed */
    if (!strcmp(fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].val.s, "")) {
	websSetVar(wp, fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].cfgkey, "no");
	fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].val.s = 
            websGetVar(wp, fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].cfgkey, "");
    }

    /* super's permissions can't be changed */
    isroot = !pp_um_user_get_uid(wp->target_user);
    excl_access_allowed = !strcmp(fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].val.s, "yes");
    if (isroot && !excl_access_allowed) {
	set_response(wp, ERIC_RESPONSE_ERROR,
		     _("Exclusive Access Mode can't be denied for super user. No settings changed."));
	return PP_ERR;
    }

    /* delete old perm entries for this object */
    if (NULL != (perms = pp_acl_objects_get_possible_perms("rc_s_excl", NULL))) {
        perms_sz = vector_size(perms);
        for (i = 0; i < perms_sz; i++) {
            pp_um_Principal_del_acl_entry(wp->target_user, "rc_s_excl", (char*)vector_get(perms, i), 1);
        }
        vector_delete(perms);
    }

    /* set perm entries */
/* FIXME: change exclusive access allowed / enabled magic!
          there is no view / change permission in RAASIP, only "yes"!
    if (!strcmp(fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].val.s, "yes")) {
        pp_um_Principal_set_acl_entry(wp->target_user, "rc_s_excl", change_perm, 0, 1);
        pp_um_Principal_set_acl_entry(wp->target_user, "rc_s_excl", view_perm, 0, 1);
    }
    if (!strcmp(fh->fv[FV_ID_RC_EXCL_ACCESS_ENABLED].val.s, "yes")) {
        pp_um_Principal_set_acl_entry(wp->target_user, "rs_s_excl", view_perm, 0, 1);
    }
*/
    if (!strcmp(fh->fv[FV_ID_RC_EXCL_ACCESS_ALLOWED].val.s, "yes") ||
        !strcmp(fh->fv[FV_ID_RC_EXCL_ACCESS_ENABLED].val.s, "yes")) {
        pp_um_user_set_perm(wp->target_user, ACL_OBJ_RC_EXCLUSIVE,
                            pp_acl_raasip_yes_str);
    }
#else /* PP_FEAT_PERM_MANAGEMENT || !PP_FEAT_RC_EXCLUSIVE_MODE || !PP_FEAT_RC_ALLOW_CHANGING_EXCLUSIVE_PERM */
    /* keep compiler silent */
    
    (void)wp;
    (void)fh;

    if (!form_button_clicked(wp, "action_apply")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }
#endif /* PP_FEAT_PERM_MANAGEMENT || !PP_FEAT_RC_EXCLUSIVE_MODE || !PP_FEAT_RC_ALLOW_CHANGING_EXCLUSIVE_PERM */
    return PP_SUC;
}

static int
rc_misc_set_vars_asp(int eid UNUSED, webs_t wp UNUSED,
                     int argc UNUSED, char ** argv UNUSED)
{

#if !defined(PP_FEAT_PERM_MANAGEMENT) && defined(PP_FEAT_RC_EXCLUSIVE_MODE) && defined(PP_FEAT_RC_ALLOW_CHANGING_EXCLUSIVE_PERM)
    /* no permission management, use explicit configuration option to allow exclusive access(rc_s_excl) */
    const char * user = wp->target_user ? wp->target_user : wp->user;
    int has_excl_perm = PP_SUC == 
            pp_um_user_has_permission(user, ACL_OBJ_RC_EXCLUSIVE,
                                      pp_acl_raasip_yes_str);
    form_handler_t *fh = lookup_form_handler(TEMPLATE_TIME_LOCAL);

    assert(fh);

    if (!websGetVar(wp, fh->fv_tmpl[FV_ID_RC_EXCL_ACCESS_ALLOWED].fvname, NULL)) {
	websSetVar(wp, fh->fv_tmpl[FV_ID_RC_EXCL_ACCESS_ALLOWED].fvname, has_excl_perm ? "yes" : "no");
    }
#elif defined(OEM_TANGTOP) && defined(PRODUCT_LARAXP)
    const char * user = wp->target_user ? wp->target_user : wp->user;
    int has_excl_perm = 
            PP_SUC == pp_um_user_has_permission(user, ACL_OBJ_RC_EXCLUSIVE,
                                                pp_acl_raasip_yes_str);
    
    websSetVar(wp, "exclusive_access_allowed", has_excl_perm ? "yes" : "no");
#else    
    (void)wp;  /* avoid unused var warning */
#endif
    return 0;
}
