#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_SEC_LOGLIM_SINGLE,
	cfgkey:		"security.single_login"
    },
    {
	id:		FV_ID_SEC_LOGLIM_PWAGING,
	cfgkey:		"security.pw_aging.enabled"
    },
    {
	id:		FV_ID_SEC_LOGLIM_PWAGING_INTERVAL,
	cfgkey:		"security.pw_aging.interval"
    },
#if defined(PRODUCT_KX2)
    {
	id:		FV_ID_SEC_LOGLIM_IDLE_TIMEOUT_ENABLED,
	cfgkey:		"security.idle_timeout.enabled"
    },
    {
	id:		FV_ID_SEC_LOGLIM_IDLE_TIMEOUT_PERIOD,
	cfgkey:		"security.idle_timeout.period"
    },
#endif /* PRODUCT_KX2 */
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
sec_loglim_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SEC_LOGLIM, ACL_OBJ_SECURITY);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh) {
    if(!form_button_clicked(wp, "action_apply")) {
        fh_disable_validate_and_save(fh, -1);
    } else {
        if(strcmp(fh->fv[FV_ID_SEC_LOGLIM_PWAGING].val.s, "yes")) {
            /* no need to check interval if password aging is disabled */
            fh->fv[FV_ID_SEC_LOGLIM_PWAGING_INTERVAL].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
        }
#if defined(PRODUCT_KX2)
        if(strcmp(fh->fv[FV_ID_SEC_LOGLIM_IDLE_TIMEOUT_ENABLED].val.s, "yes")) {
            /* no need to check interval if password aging is disabled */
            fh->fv[FV_ID_SEC_LOGLIM_IDLE_TIMEOUT_PERIOD].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
        }
#endif /* PRODUCT_KX2 */
    }

    return 0;
}

static int
post_validate_hook(webs_t wp UNUSED, form_handler_t * fh) {
#if defined(PRODUCT_KX2)
    if(strcmp(fh->fv[FV_ID_SEC_LOGLIM_SINGLE].val.s, "yes")) {
        websSetVar(wp, fh->fv[FV_ID_SEC_LOGLIM_SINGLE].fvname, "yes");
    } else {
        websSetVar(wp, fh->fv[FV_ID_SEC_LOGLIM_SINGLE].fvname, "no");
    }
    fh->fv[FV_ID_SEC_LOGLIM_SINGLE].val.s = websGetVar(wp, fh->fv[FV_ID_SEC_LOGLIM_SINGLE].fvname, "");
#else /* !PRODUCT_KX2 */
    (void)fh;
#endif /* !PRODUCT_KX2 */

    return 0;
}

