#include <liberic_cert.h>
#include <pp/um.h>
#include <pp/intl.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_CERT_C,
	cfgkey:		"ssl.c"
    },
    {
	id:		FV_ID_CERT_ST,
	cfgkey:		"ssl.st"
    },
    {
	id:		FV_ID_CERT_L,
	cfgkey:		"ssl.l"
    },
    {
	id:		FV_ID_CERT_O,
	cfgkey:		"ssl.o"
    },
    {
	id:		FV_ID_CERT_OU,
	cfgkey:		"ssl.ou"
    },
    {
	id:		FV_ID_CERT_CN,
	cfgkey:		"ssl.cn"
    },
    {
	id:		FV_ID_CERT_EMAIL,
	cfgkey:		"ssl.email"
    },
    {
	id:		FV_ID_CERT_CHALLENGE,
	cfgkey:		"ssl.challenge"
    },
    {
	id:		FV_ID_CERT_BITS,
	cfgkey:		"ssl.key_len"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
sec_server_cert_csr_tmpl_init(void)
{
    form_handler_t * fh;

    if (sec_server_cert_common_tmpl_init() != 0) return -1;
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_SEC_SERVER_CERT_CSR, ACL_OBJ_SECURITY);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    size_t i;
    u_int bits;
    int error;

    /* No global validate - only our own template (manually) */
    if (form_button_clicked(wp, "action_create_csr")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	for (i = 0; i < fh->fv_cnt; ++i) {
	    form_var_t * fv = &fh->fv[i];
	    if (fv->flags & FV_FLAG_SKIP_VALIDATE) continue;
	    if (!validate_form_var(wp, fv)) {
		return -1;
	    }
	}

	/* check the challenge passwords for equivalence */
	if (strcmp(fh->fv[FV_ID_CERT_CHALLENGE].val.s, 
                   websGetVar(wp, "confirm_pw", ""))) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("The two passwords don't match."));
	    return -1;
	}

	/* we assume that strtoul wents ok since the validation went ok */
	bits = strtoul(fh->fv[FV_ID_CERT_BITS].val.s, NULL, 10);
	eric_cert_create_key(fh->fv[FV_ID_CERT_C].val.s,
			     fh->fv[FV_ID_CERT_ST].val.s,
			     fh->fv[FV_ID_CERT_L].val.s,
			     fh->fv[FV_ID_CERT_O].val.s,
			     fh->fv[FV_ID_CERT_OU].val.s,
			     fh->fv[FV_ID_CERT_CN].val.s,
			     fh->fv[FV_ID_CERT_EMAIL].val.s,
			     fh->fv[FV_ID_CERT_CHALLENGE].val.s,
			     bits, &error);

	if (error) {
	    set_response(wp, ERIC_RESPONSE_ERROR, eric_cert_get_error_string(error));
	    return -1;
	}
	delete_fh_form_vars(wp, fh);
    } else {
	fh_disable_validate_and_save(fh, -1);
    }

    if (form_button_clicked(wp, "action_download_csr")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	if ((wp->cert_data = balloc(B_L, ERIC_CERT_MAX_FILESIZE)) == NULL) {
	    set_response(wp, ERIC_RESPONSE_ERROR, internal_error_msg);
	} else {
	    wp->cert_data_size = ERIC_CERT_MAX_FILESIZE;
	    eric_cert_get_csr(wp->cert_data, &wp->cert_data_size, &error);
	    strcpy(wp->type, "application/octet-stream");
	    wp->numbytes = wp->cert_data_size;
	    wp->download_image = wp->cert_data;
	    wp->download_name = ERIC_CERT_CSR_FILENAME;
	    wp->download_cb = mem_image_download_cb;
	}
    } else if (form_button_clicked(wp, "action_delete_csr")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	set_response(wp, ERIC_RESPONSE_OK,
		     _("This will delete the CSR and the corresponding key. "
		     "You will not get it back! Please confirm by pressing "
		       "\"Really Delete\"!"));
	websSetVar(wp, "_show_delete_csr_confirm", "1");
    } else if (form_button_clicked(wp, "action_really_delete_csr")) {
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
	eric_cert_delete_key(&error);
	if (error) {
	    set_response(wp, ERIC_RESPONSE_ERROR, eric_cert_get_error_string(error));
	    return -1;
	}
	set_response(wp, ERIC_RESPONSE_OK, _("CSR deleted successfully."));
    }

    return 0;
}
