#include <pp/cfg.h>
#include <pp/intl.h>
#include "eric_base.h"
#include "eric_forms.h"
#include "eric_util.h"

#if defined(PRODUCT_ICPMMD)

FV_SPEC = {
    {
	id:		FV_ID_SERIAL_BLADE_LINE_SPEED,
	cfgkey:		"serialport.passthrough.speed"
    },
    {
	id:		FV_ID_SERIAL_BLADE_DATA,
	cfgkey:		"serialport.passthrough.data"
    },
    {
	id:		FV_ID_SERIAL_BLADE_PARITY,
	cfgkey:		"serialport.passthrough.parity"
    },
    {
	id:		FV_ID_SERIAL_BLADE_STOP,
	cfgkey:		"serialport.passthrough.stop"
    },
};

int
serial_blade_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SERIAL_BLADE, ACL_OBJ_SERIAL);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

#else /* !PRODUCT_ICPMMD */

int serial_blade_tmpl_init(void) { return 0; }

#endif /* !PRODUCT_ICPMMD */
