#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_SNMP_AGENT_ENABLED,
	cfgkey:		"snmp.agent_enabled"
    },
    {
	id:		FV_ID_SNMP_READ_COMMUNITY,
	cfgkey:		"snmp.read_community"
    },
    {
	id:		FV_ID_SNMP_WRITE_COMMUNITY,
	cfgkey:		"snmp.write_community"
    },
    {
	id:		FV_ID_SNMP_SYS_LOCATION,
	cfgkey:		"snmp.sys_location"
    },
    {
	id:		FV_ID_SNMP_SYS_CONTACT,
	cfgkey:		"snmp.sys_contact"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
snmp_agent_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_SNMP_AGENT, ACL_OBJ_SNMP);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED,  form_handler_t * fh)
{
    if (strcmp(fh->fv[FV_ID_SNMP_AGENT_ENABLED].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_SNMP_AGENT_ENABLED);
    }
    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    if (!strcmp(fh->fv[FV_ID_SNMP_AGENT_ENABLED].val.s, "yes")
	&& !strcmp(fh->fv[FV_ID_SNMP_READ_COMMUNITY].val.s,
		   fh->fv[FV_ID_SNMP_WRITE_COMMUNITY].val.s)) {
	set_response(wp, ERIC_RESPONSE_ERROR,
		     "The '%s' and '%s' need to be different.",
		     fh->fv[FV_ID_SNMP_READ_COMMUNITY].label,
		     fh->fv[FV_ID_SNMP_WRITE_COMMUNITY].label);
	return -1;
    }
    return 0;
}

