#include <liberic_net.h>
#include <pp/cfg.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

FV_SPEC = {
    {
	id:		FV_ID_NTP_SERVER_1,
	cfgkey:		"time.proto.ntp.server_1"
    },
    {
	id:		FV_ID_NTP_SERVER_2,
	cfgkey:		"time.proto.ntp.server_2"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
time_ntp_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_TIME_NTP, ACL_OBJ_TIME);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    char * time_proto = get_form_var_value_unsaved(wp, TEMPLATE_TIME, FV_ID_TIME_PROTO);
    char * conf_proto = NULL;
    pp_cfg_get_nodflt(&conf_proto, "network.ip_auto_config_proto");
    printf("%s, %s\n", time_proto, conf_proto);
    if ( pp_strcmp_safe(time_proto, "ntp")
      || pp_strcmp_safe(conf_proto, "none") ) {
	fh_disable_validate_and_save(fh, -1);
    }
    free(time_proto);
    free(conf_proto);
    return 0;
}
