#ifndef _WEBS_TMPL_VFLOPPY_COMMON_H
#define _WEBS_TMPL_VFLOPPY_COMMON_H

#include <sys/types.h>
#include <pp/features.h>
#include "eric_base.h"

/* allow discarding all vfloppy images */
#define VFLOPPY_DISCARD_SKIP_SESSION_CHECK (1<<0)

/* allow discarding all vfloppy images of the same user */
#define VFLOPPY_DISCARD_LAZY_SESSION_CHECK (1<<1)

#define MAX_VFLOPPY_FILENAME 128

typedef struct {

    /* mutually excludes multiple uploads */
    pthread_mutex_t upload_mtx;

    /*
     * When this session terminates (e.g. the session data is freed), the
     * virtual media is discarded.
     */
    eric_session_int_id_t owning_session;

    /* the file name in the tmpfs */
    char filename[MAX_VFLOPPY_FILENAME];

    /* the name of the vfloppy image */
    char name[1024];

    /* the real size of the vfloppy */
    size_t size;

    /* flag indicating an uploaded vfloppy */
    int is_loaded;

    /*
     * the file descriptor for accessing the data
     *
     * NOTE: The corresponding file is unlinked on disk
     *	     right after opening it. If you close it it
     *	     will be lost!
     */
    int fd;

} vfloppy_data_t;

extern vfloppy_data_t vfloppy_data[PP_FEAT_USB_MASS_STORAGE_NO];

void vfloppy_discard(u_int ms_index);
int vfloppy_session_check(eric_session_int_id_t wp_session, u_int ms_index, u_int flags);

#endif /* _WEBS_TMPL_VFLOPPY_COMMON_H */
