#include <pp/um.h>
#include <pp/vsc.h>
#include <pp/intl.h>
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

#ifdef PP_FEAT_VIDEO_CUSTOM_MODES

FV_SPEC = {
    {
	id:		FV_ID_VIDEO_CUSTOM_MODE,
	cfgkey:		"video.tft_custom.mode"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_X,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "x"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_Y,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "y"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_H,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "h"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_V,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "v"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_CLOCK,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "clock"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_POLARITY,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "polarity"
    },
    {
	id:		FV_ID_VIDEO_CUSTOM_NAME,
	cfgkey:		"video.tft_custom.settings[%I]",
        elemkey:        "name"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int video_custom_modes_set_vars_asp(int eid, webs_t wp, 
                                           int argc, char ** argv);

int
video_custom_modes_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("videoCustomModesSetVars", video_custom_modes_set_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_VIDEO_CUSTOM_MODES, ACL_OBJ_VIDEO);

    fh->pre_validate_hook = pre_validate_hook;
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    if (form_button_clicked(wp, "action_mode_update")) {
        /* delete form vars! __target_mode__ is not affected... */
        delete_form_vars(wp);
	wp->fh_flags |= FH_FLAG_ABORT_AT_VALIDATE;
    }
    return 0;
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh)
{
    char fvkey[FV_KEY_MAX_LEN];
    const char * fvval;
    form_var_t * fv;
    u_int i;
    u_int target_mode;
    
    if(!strcmp(fh->fv[FV_ID_VIDEO_CUSTOM_MODE].val.s, "off")) {
        return 0;
    }
        
    target_mode = pp_strtoul_10(websGetVar(wp, "__target_mode__", NULL),
                                0, NULL);
    for (i = 0; i < fh->fv_cnt; ++i) {
	fv = &fh->fv[i];
        /* the vars are flagged "allow_empty" and "dont_safe_empty" to
           allow changes to only one video profile (vector index). the
           variables of one profile must not be empty though! */
        form_var_vec_name(fv->fvname, target_mode, fvkey, sizeof(fvkey));
        fvval = websGetVar(wp, fvkey, "");
        if (*fvval == '\0' && PP_CD_TYPE_IS_VECTOR_TEMPL(fv->realtype)) {
            set_response(wp, ERIC_RESPONSE_ERROR, 
                         _("The '%s' must not be empty."), fv->label);
            wp->fh_flags |= FH_FLAG_ABORT_AT_SAVE;
            return -1;
        }
    }
    return 0;
}

static int
video_custom_modes_set_vars_asp(int eid UNUSED, webs_t wp,
                                int argc UNUSED, char ** argv UNUSED)
{
    const char * target_mode = websGetVar(wp, "__target_mode__", NULL);
    if (target_mode == NULL) target_mode = "0";
    websSetVar(wp, "__target_mode__", target_mode);
    return 0;
}

#else /* !PP_FEAT_VIDEO_CUSTOM_MODES */

int video_custom_modes_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_VIDEO_CUSTOM_MODES */
