#define __t__ TEMPLATE_IPMI_SEL
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
  <% _ipmi_enabled = 1; %>
#else
  <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif

  COND_SHOW_BEGIN(!_ipmi_enabled)
    NOTICE_BEGIN(center)
      A_("IPMI support is not enabled. You should check the") IPMI_SETTINGS().
    NOTICE_END()
  COND_SHOW_END(!_ipmi_enabled)

  COND_SHOW_BEGIN(_ipmi_enabled)
#if !defined(PP_FEAT_RARITAN_DESIGN)
    DIALOGTABLE_BEGIN()
        <tr class="loggingHeader">
            <td class="bold">A_("Event Type")</td>
            <td class="bold">A_("Date")</td>
            <td class="bold">A_("Time")</td>
            <td class="bold">A_("Source")</td>
            <td class="bold">A_("Description")</td>
            <td class="bold">A_("Direction")</td>
        </tr>
        <tr id="wait">
            <td colspan=6>A_("Loading event log, please wait...")</td>
        </tr>
        <% if (_ipmi_enabled) write(ipmiGetSelTable()); %>
    DIALOGTABLE_END()
    SUBMIT_BUTTON(T_("Clear"), "clear", "clear_log", "")
    SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")
    <script type="text/javascript">
      <!--
        document.getElementById("wait").style.display = "none";
      -->
    </script>
#else
	TABLE_SCRIPT()
	<script>
	table_start('A_("Event Type")','A_("Date")','A_("Time")','A_("Source")','A_("Description")','A_("Direction")');
	</script>
        <% if (_ipmi_enabled) write(ipmiGetSelTable()); %>
	<script>
	table_end();
	</script>
	<center>
	SUBMIT_BUTTON(T_("Clear"), "clear", "clear_log", "")
	SUBMIT_BUTTON(T_("Refresh"), "refresh", "refresh", "")
	</center>
#endif	
  COND_SHOW_END(_ipmi_enabled)

TMPL_END()
