#define __t__ TEMPLATE_IPMI_STATUS
TMPL_BEGIN()

#if defined(PP_FEAT_IPMI_SERVER)
  <% _ipmi_enabled = 1; %>
#else
  <% _ipmi_enabled = (FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != "none" && FMT(TEMPLATE_IPMI, FV_ID_IPMI_MEDIUM) != ""); %>
#endif
  <% if (_ipmi_enabled) ipmiGetSensorData(); %>

  COND_SHOW_BEGIN(!_ipmi_enabled)
    NOTICE_BEGIN(center)
      A_("IPMI support is not enabled. You should check the") IPMI_SETTINGS().
    NOTICE_END()
  COND_SHOW_END(!_ipmi_enabled)

  COND_SHOW_BEGIN(_ipmi_enabled)
      GROUP_BEGIN(A_("Fan Status"))
      DIALOGTABLE_BEGIN()
        <tr>
	  <td valign="top" class="bold">A_("Name")</td>
	  <td valign="top" class="bold">A_("Status")</td>
	  <td valign="top" class="bold">A_("Value")</td>
	  <td valign="top" class="bold">A_("Min<br>(crit.)")</td>
	  <td valign="top" class="bold">A_("Min")</td>
	  <td valign="top"></td>
	  <td valign="top"></td>
	</tr>
	<% for (i = 0; i < fan_id_cnt; i++) {
	       write('<tr>\n',
		     '<td class="normal nowrap">', htmlEsc(getVarByIdx("fan_name", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("fan_status", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("fan_value", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("fan_min_crit", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("fan_min", i)), '</td>\n',
		     '<td></td>\n<td></td>\n</tr>\n');
	   }
	%>
      DIALOGTABLE_END()
    GROUP_END()
    GROUP_BEGIN(A_("Temperature Status"))
      DIALOGTABLE_BEGIN()
	<tr>
          <td valign="top" class="bold">A_("Name")</td>
	  <td valign="top" class="bold">A_("Status")</td>
	  <td valign="top" class="bold">A_("Value")</td>
	  <td valign="top" class="bold">A_("Min<br>(crit.)")</td>
	  <td valign="top" class="bold">A_("Min")</td>
	  <td valign="top" class="bold">A_("Max")</td>
	  <td valign="top" class="bold">A_("Max<br>(crit.)")</td>
	</tr>
        <% for (i = 0; i < temp_id_cnt; i++) {
	       write("<tr>\n" +
		     '<td class="normal nowrap">', htmlEsc(getVarByIdx("temp_name", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("temp_status", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("temp_value", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("temp_min_crit", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("temp_min", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("temp_max", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("temp_max_crit", i)), '</td>\n',
		     '</tr>\n');
	   }
	%>
       DIALOGTABLE_END()
    GROUP_END()
    GROUP_BEGIN(A_("Voltages"))
      DIALOGTABLE_BEGIN()
        <tr>
          <td valign="top" class="bold">A_("Name")</td>
	  <td valign="top" class="bold">A_("Status")</td>
	  <td valign="top" class="bold">A_("Value")</td>
	  <td valign="top" class="bold">A_("Min<br>(crit.)")</td>
	  <td valign="top" class="bold">A_("Min")</td>
	  <td valign="top" class="bold">A_("Max")</td>
	  <td valign="top" class="bold">A_("Max<br>(crit.)")</td>
	</tr>
        <% for (i = 0; i < voltage_id_cnt; i++) {
	       write("<tr>\n" +
		     '<td class="normal nowrap">', htmlEsc(getVarByIdx("voltage_name", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("voltage_status", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("voltage_value", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("voltage_min_crit", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("voltage_min", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("voltage_max", i)), '</td>\n',
		     '<td class="normal">', htmlEsc(getVarByIdx("voltage_max_crit", i)), '</td>\n',
		     '</tr>\n');
           }
	%>
      DIALOGTABLE_END()
    GROUP_END()
  COND_SHOW_END(_ipmi_enabled)

TMPL_END()
