#define __t__ TEMPLATE_KVM
TMPL_BEGIN()

DIALOGTABLE_BEGIN()

#ifdef PRODUCT_XX01IP_ANY
  <% _unit_port_count = kvmGetUnitPortCount(__target_unit__); %>
  VARIABLE(FMS(FV_ID_KVM_UNIT_PORT_COUNT), "<% write(_unit_port_count); %>")
#else /* !PRODUCT_XX01IP_ANY */
  <% _unit_port_count = FM(FV_ID_KVM_UNIT_PORT_COUNT); %>
  <tr>
     DIALOGTABLE_NEWCOL()
      <td class="settings_fieldname">A_("Number of Ports")
      DIALOGTABLE_SPACER()
      <select <%isDisabled(FV_ID_KVM_UNIT_PORT_COUNT);%> name=FMS(FV_ID_KVM_UNIT_PORT_COUNT)
	    onchange="getElement('name', 'action_' + 'update_kvm_port', 0).click()">
	<option value="1" <% if (_unit_port_count == "1") { write("selected"); } %>>1
	<option value="2" <% if (_unit_port_count == "2") { write("selected"); } %>>2
	<option value="4" <% if (_unit_port_count == "4") { write("selected"); } %>>4
	<option value="8" <% if (_unit_port_count == "8") { write("selected"); } %>>8
	<option value="12" <% if (_unit_port_count == "12"){ write("selected"); } %>>12
	<option value="16" <% if (_unit_port_count == "16"){ write("selected"); } %>>16
	<option value="24" <% if (_unit_port_count == "24"){ write("selected"); } %>>24
	<option value="32" <% if (_unit_port_count == "32"){ write("selected"); } %>>32
	<option value="48" <% if (_unit_port_count == "48"){ write("selected"); } %>>48
	<option value="64" <% if (_unit_port_count == "64"){ write("selected"); } %>>64
      </select>
      <%isDefault(FV_ID_KVM_UNIT_PORT_COUNT, -1);%>
#if !defined(PP_FEAT_RARITAN_DESIGN)
      </td>
      <td>
      CENTER(SUBMIT_BUTTON(T_("Update"), "update", "update_kvm_port", ""))
#else
      SUBMIT_BUTTON(T_("Update"), "update", "update_kvm_port", "")
#endif	
    </td>
  </tr>
  COND_SHOW_BEGIN(kvm_default_entry_cnt > 0)
  <tr>
     DIALOGTABLE_NEWCOL()
    <td class="settings_fieldname">A_("Default Configuration")
    DIALOGTABLE_SPACER()
      <select <%isDisabled(FV_ID_KVM_UNIT_PORT_COUNT);%> name="kvm_default_idx">
      <% 
	for (i = 0; i < kvm_default_entry_cnt; i++) {
	  write('<option value="' + i + '">' + htmlEsc(getVarByIdx("kvm_default_entry", i)));
	}
      %>
      </select>
    </td>
    <td>
      SUBMIT_BUTTON(T_("Set Defaults"), "set_defaults", "set_defaults", "")
    </td>
   </tr>
  COND_SHOW_END(kvm_default_entry_cnt > 0)
  <tr>
     DIALOGTABLE_NEWCOL()
     <td class="settings_fieldname">A_("Pause duration")
#if !defined(PP_FEAT_RARITAN_DESIGN)
      </td><td class="settings_field" colspan="2">
#else
    DIALOGTABLE_SPACER()
#endif    
    <% if (FM(FV_ID_KVM_KEY_PAUSE_DURATION) == "") { FM(FV_ID_KVM_KEY_PAUSE_DURATION) = 100; } %>
    <input <%isDisabled(FV_ID_KVM_KEY_PAUSE_DURATION);%> type="text" name=FMS(FV_ID_KVM_KEY_PAUSE_DURATION) 
	     size="5" value="<% write(FM(FV_ID_KVM_KEY_PAUSE_DURATION)); %>">&nbsp;A_("ms")&nbsp;
      <%isDefault(FV_ID_KVM_KEY_PAUSE_DURATION);%>
      A_("(for KVM and Remote Console Button Keys)")
    </td>
  </tr>
#endif /* !PRODUCT_XX01IP_ANY */
  COND_SHOW_BEGIN(_unit_port_count > 1)
  <tr>
      <td>&nbsp;</td>
  </tr>
  <tr>
    <td class="emph" colspan="2">A_("Port Configuration")</td>
  </tr>
    VARIABLE(FMSZS(FV_ID_KVM_HOTKEY), "<% write(_unit_port_count); %>")
    VARIABLE(FMSZS(FV_ID_KVM_HOTKEYCODE), "<% write(_unit_port_count); %>")
    VARIABLE(FMSZS(FV_ID_KVM_PORTNAME), "<% write(_unit_port_count); %>")
    VARIABLE(FMSZS(FV_ID_KVM_SHOW_IN_RC), "<% write(_unit_port_count); %>")
   <tr>
#if defined(PP_FEAT_RARITAN_DESIGN)
   <td>
      <table border="0" cellspacing="0" cellpadding="0">
      <tr>										        
#endif      
#if defined(OEM_BELKIN)
    <td class="settings_fieldname emph">A_("#")</td>
#else
     <td class="settings_fieldname emph">A_("Nr")</td>
#endif
     <td class="settings_field emph">A_("Name")</td>
#if !defined(PRODUCT_XX01IP_ANY)
    <td class="settings_field emph">A_("Hotkey")
    (
#if defined(OEM_BELKIN)
	<a href="help.asp#rc_hotkeys" target="_blank">(A_("Help"))</a>
#else
	<a href="help_hotkeys.asp#rc_hotkeys" target="_blank">(A_("Help"))</a>
#endif
    )</td>
#endif /* !PRODUCT_XX01IP_ANY */
    <td class="settings_field emph">A_("Show in Console")</td>
#if defined(PP_FEAT_KVM_PORT_POWER)
    <td class="settings_field emph">A_("Power Control")</td>
#endif /* PP_FEAT_KVM_PORT_POWER */
   </tr>
   <% for (i = 0; i < _unit_port_count; i++) {
	write('<tr>\n  <td class="settings_fieldname_checkbox emph">\n', kvmGetPortnameFromIndex(i), '  </td>\n  <td class="settings_field">\n',
	      '	 <input ', isDisabledStr(FV_ID_KVM_UNIT_PORT_COUNT), ' type="text" name="' + FMIS(FV_ID_KVM_PORTNAME, i) +
	      '" maxlength="20" size="20" value="' +
	      htmlEsc(FMI(FV_ID_KVM_PORTNAME, i)) + '">' +
              isDefaultStr(FV_ID_KVM_PORTNAME, i) + '\n  </td>\n');
#ifdef PRODUCT_XX01IP_ANY
	write('<td class="settings_field"><input type="hidden" name="' + FMIS(FV_ID_KVM_HOTKEY, i) + '" value="' + htmlEsc(FMI(FV_ID_KVM_HOTKEY, i)) + '">\n', 
#else /* !PRODUCT_XX01IP_ANY */
	write('<td class="settings_field">\n<input ', isDisabledStr(FV_ID_KVM_UNIT_PORT_COUNT), ' type="text" name="' + FMIS(FV_ID_KVM_HOTKEY, i) +
	      '" maxlength="64" size="24" value="' +
	      htmlEsc(FMI(FV_ID_KVM_HOTKEY, i)) + '">' +
              isDefaultStr(FV_ID_KVM_HOTKEY, i) + '\n	</td>\n	 <td align="center">\n',
#endif /* !PRODUCT_XX01IP_ANY */
	      '	<input ', isDisabledStr(FV_ID_KVM_UNIT_PORT_COUNT), ' type="checkbox" name="' + FMIS(FV_ID_KVM_SHOW_IN_RC, i) + '" value="yes"');
	if (FMI(FV_ID_KVM_SHOW_IN_RC, i) == "yes") { write(" checked"); }
	write(">" + isDefaultStr(FV_ID_KVM_SHOW_IN_RC, i) + "</td>\n");
#if defined(PP_FEAT_KVM_PORT_POWER)
	write('<td class="settings_field"><a href="kvm_powerctrl.asp?__target_unit__=0&__target_port__=' + i + '">', T_("Assign"), '</a></td>');
#endif /* PP_FEAT_KVM_PORT_POWER */
	write("</tr>\n");
      }
   %>
#if defined(PP_FEAT_RARITAN_DESIGN)
      </table>
      </td>
      </tr>
#endif      
	COND_SHOW_END(_unit_port_count > 1)

DIALOGTABLE_END()

TMPL_END()
