#define __t__ TEMPLATE_LOG
TMPL_BEGIN()

<% logSetVars(); %>

<% allow_change = aclHasPermission("log_s", "yes") == "yes";  %>

#if !defined(PP_FEAT_RARITAN_DESIGN)
DIALOGTABLE_BEGIN()
  <tr>
    <td class="center" colspan="3">[ 
      <% if (log_show_prev_button) { write('<a href="?action_log_prev=yes&__templates__=log">'); } %> A_("Prev")
      <% if (log_show_prev_button) { write('</a>'); } %> ][	          
      <% if (log_show_next_button) { write('<a href="?action_log_next=yes&__templates__=log">'); } %> A_("Next")
      <% if (log_show_next_button) { write('</a>'); } %> ]
    </td>
  </tr>
  <tr class="loggingHeader">
    <td class="bold">A_("Date")</td>
    <td class="bold">A_("Event")</td>
    <td class="bold">A_("Description")</td>		
  </tr>	   
  <% for (i = 0; i < log_entry_cnt; i++) {
         if ( i % 2 ) {
	     write('<tr class="loggingRowOdd">');
	 } else {
	     write('<tr class="loggingRowEven">');
	 }
	 write('<td>', htmlEsc(getVarByIdx("log_entry_date", i)), '</td>\n',
	       '<td>', htmlEsc(getVarByIdx("log_entry_event", i)), '</td>\n',
	       '<td class="wrap">', htmlEsc(getVarByIdx("log_entry_desc", i)), '</td></tr>\n');
     }
  %>
  <tr>
    <td class="center" colspan="3">[ 
      <% if (log_show_prev_button) { write('<a href="?action_log_prev=yes&__templates__=log">'); } %> A_("Prev")
      <% if (log_show_prev_button) { write('</a>'); } %> ][	          
      <% if (log_show_next_button) { write('<a href="?action_log_next=yes&__templates__=log">'); } %> A_("Next")
      <% if (log_show_next_button) { write('</a>'); } %> ]
    </td>
  </tr>
COND_SHOW_BEGIN(allow_change)
  <tr>
    <td class="center" colspan="3">A_("Clear internal log")
	SMART_SUBMIT_BUTTON(T_("Clear"), "clear", "log_clear", T_("Really Clear"), "r_clear", "really_log_clear", _show_log_clear_confirm, "logListUpdateStateSlaves")
      COND_SHOW_BEGIN(_show_log_clear_confirm)
        SUBMIT_BUTTON(T_("Cancel"), "cancel", "cancel_log_clear", "logListUpdateStateSlaves")
      COND_SHOW_END(_show_log_clear_confirm)
    </td>
  </tr>
COND_SHOW_END(allow_change)
DIALOGTABLE_END()
#else
  TABLE_SCRIPT()        
  <% if (log_show_prev_button) {
         write('[ <a href="?action_log_prev=yes&__templates__=log">'); 
	 _("Prev");
	 write('</a> ] '); } %>
  <% if (log_show_next_button) {
         write('[ <a href="?action_log_next=yes&__templates__=log">'); 
	 _("Next");
	 write('</a> ] '); } %>      
  <br><br>
  <script>
        table_start('A_("Date")','A_("Event")','A_("Description")');
  </script>
	 <% for (i = 0; i < log_entry_cnt; i++) {
		  write('<script> table_entry(', '"'); 
		  write(htmlEsc(getVarByIdx("log_entry_date", i)));
		  write('","');
		  write(htmlEsc(getVarByIdx("log_entry_event", i)));
		  write('","');
		  write(htmlEsc(getVarByIdx("log_entry_desc", i)));
		  write('")</script>');
	 } %>
  <script>
	 table_end();
  </script>
COND_SHOW_BEGIN(allow_change)
  SMART_SUBMIT_BUTTON(T_("Clear"), "clear", "log_clear", T_("Really Clear"), "r_clear", "really_log_clear", _show_log_clear_confirm, "logListUpdateStateSlaves")
  COND_SHOW_BEGIN(_show_log_clear_confirm)
    SUBMIT_BUTTON(T_("Cancel"), "cancel", "cancel_log_clear", "logListUpdateStateSlaves")
  COND_SHOW_END(_show_log_clear_confirm)
COND_SHOW_END(allow_change)
#endif  

TMPL_END()
