#define __t__ TEMPLATE_POWER_CONTROL_DIRECT
TMPL_BEGIN()
<% pcDirectSetVars();
   _ps_cap_switch_serial1 = psHasCapability("switch", "serial1");
   _ps_cap_switch_serial2 = psHasCapability("switch", "serial2");
   _ps_cap_state_serial1 = psHasCapability("state", "serial1");
   _ps_cap_state_serial2 = psHasCapability("state", "serial2");
   _ps_cap_temp_serial1 = psHasCapability("temp", "serial1");
   _ps_cap_temp_serial2 = psHasCapability("temp", "serial2");
   _ps_cap_switch_ext_serial1 = psHasCapability("switch_ext", "serial1");
   _ps_cap_switch_ext_serial2 = psHasCapability("switch_ext", "serial2");
   _ps_cap_switch_seq_serial1 = psHasCapability("switch_seq", "serial1");
   _ps_cap_switch_seq_serial2 = psHasCapability("switch_seq", "serial2");
   _ps_cap_switch_all_serial1 = psHasCapability("switch_all", "serial1");
   _ps_cap_switch_all_serial2 = psHasCapability("switch_all", "serial2");
   _ps_cap_switch_simultan_serial1 = psHasCapability("switch_simultan", "serial1");
   _ps_cap_switch_simultan_serial2 = psHasCapability("switch_simultan", "serial2");
   _ps_cap_reset_serial1 = psHasCapability("reset", "serial1");
   _ps_cap_reset_serial2 = psHasCapability("reset", "serial2");
   _show = ((EC.serialport[0]._c_ == "externalpower" && EC.ps.serial[0]._c_ != "") ||
	    (EC.serialport[1]._c_ == "externalpower" && EC.ps.serial[1]._c_ != ""));
   _serial2_intern_switch = (EC.serialport[1]._c_ == "externalpower" && EC.ps.serial[1]._c_ == "intern");
   _host_has_power = getHostInfo("power");
%>

COND_SHOW_BEGIN(_show)

DIALOGTABLE_BEGIN()
  <colgroup>
    <col width="50%">
    <col width="50%">
  </colgroup>

  COND_SHOW_BEGIN(_ps_err_msg_serial1 != "")
    NOTICE_BEGIN(center)
    <% write(_ps_err_msg_serial1); %>
    NOTICE_END()
  COND_SHOW_END(_ps_err_msg_serial1 != "")
  
  COND_SHOW_BEGIN(power_entry_serial1_cnt >= 1 && power_device_serial1_cnt > 0)
  <tr>
    <td align="left" class="bold" height="50">Serial Port 1:</td>
    <td align="center" class="bold">
      <%
	writeEsc(_ps_name_serial1);
        pds1name = getVarByIdx("power_device_serial1", 0);
        if ( power_device_serial1_cnt == 1 && pds1name != "" ) {
	    write(" - " + htmlEsc(pds1name));
        }
      %>
    </td>
  </tr>

  COND_SHOW_BEGIN(power_device_serial1_cnt > 1)
  <tr>
    <td align="left" class="normal">A_("Device:")</td>
    <td align="center">
    <select name=FMS(FV_ID_PC_POWER_DEVICE_0)>
        <% for (i = 0; i < power_device_serial1_cnt; i++) {
	       write('<option value="' + i + '"');
	       _entry = getVarByIdx("power_device_serial1", i);
	       if (i == current_power_device_serial1) { write(" selected"); }
	       write(">", htmlEsc(_entry), "\n");
           }
	%>
      </select>
    </td>
  </tr>
  COND_SHOW_END(power_device_serial1_cnt > 1)
  <tr>
    <td colspan="2" align="center">
    COND_SHOW_BEGIN(_ps_cap_switch_simultan_serial1)
    SUBMIT_BUTTON(T_("Update"), "update", "update_power_device_serial1", "")
    COND_SHOW_END(_ps_cap_switch_simultan_serial1)
    </td>
  </tr>
#if !defined(OEM_TANGTOP)	  
  COND_SHOW_BEGIN(power_entry_serial1_cnt > 1 && _ps_cap_switch_serial1 )
  <tr><td align="center" class="bold" height="50" colspan="2">A_("Single Port Switch")</td></tr>
  <tr>
    <td align="left" class="normal">A_("Port:")</td>
    <td align="center">
      <select name=FMS(FV_ID_PC_POWER_PORT_0)>
        <% for (i = 0; i < power_entry_serial1_cnt; i++) {
	       write('<option value="' + i + '"');
	       _entry = getVarByIdx("power_entry_serial1", i);
	       if (i == current_power_entry_serial1) { write(" selected"); }
	       write(">", htmlEsc(_entry), "\n");
           }
        %>   
      </select>
    </td>
  </tr>
  COND_SHOW_END(power_entry_serial1_cnt > 1 && _ps_cap_switch_serial1)
	  
  COND_SHOW_BEGIN(_ps_cap_switch_serial1)
  <tr>
    <td align="center">SUBMIT_BUTTON(T_("Power On"), "poweron", "power_on_direct_serial1", "")</td>
    <td align="center">SUBMIT_BUTTON(T_("Power Off"), "poweroff", "power_off_direct_serial1", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_switch_serial1)
#else
  <tr>
    <td>A_("Current Value:")</td>
    <td align="center"><% writeEsc(_ps_power_current_value); %></td>
  </tr>
  <tr>
    <td align="left" class="normal nowrap">A_("Use Power On Delays:") </td>
    <td align="center"><% if (_ps_power_use_power_on_delays == "on") { write('<input type="image" src="button_on.en.gif" name="action_delay_time_on' + '_serial1" value="On" align="middle">'); }
	    else { write('<input type="image" src="button_off.en.gif" name="action_delay_time_off' + '_serial1" value="Off" align="middle">'); } %>
    </td>
  </tr>
  <tr>
    <td colspan="2">
      NOTICE_BEGIN(center)
	A_("Delay time seconds are displayed in braces below the outlet names. They can be configured in") INTERNAL_POWER_CONTROL_SETTINGS()
      NOTICE_END()
    </td>
  </tr>
  <tr><td align="center" class="bold" height="50" colspan="2">A_("Single Outlet Switch")</td></tr>
  <tr>
      <td colspan="2">
    <table align="center">
      <tr>
#comment hack: to generate on/off buttons
COND_SHOW_BEGIN(0)
  <tr>
    <td align="center">SUBMIT_BUTTON(T_("On"), "on", "power_on_direct_serial1", "")</td>
    <td align="center">SUBMIT_BUTTON(T_("Off"), "off", "power_off_direct_serial1", "")</td>
  </tr>
COND_SHOW_END(0)
      <% for (i = 0; i < power_entry_serial1_cnt; i++) {
	    _entry = getVarByIdx("power_entry_serial1", i);
	    _value = getVarByIdx("_ps_ipwr_port_values", i);
	    _delay = getVarByIdx("_ps_ipwr_port_delay", i);
	    if ( i == 4 || i == 8 || i == 12 ) {
		write('\n</tr><tr>\n');
	    }	    
	    write('<td>\n
                       <table class="cb_field">\n
                         <tr><td align="center" class="normal nowrap">' + _entry + '</td></tr>\n
			 <tr><td align="center" class="normal nowrap">(' + _delay + 's)</td></tr>\n
                         <tr><td align="center">');
	    if (_value == "on") { write('<input type="image" src="button_on.en.gif" name="action_power_on_port_' + i + '_serial1" value="On" align="middle">'); }
	    else { write('<input type="image" src="button_off.en.gif" name="action_power_off_port_' + i + '_serial1" value="Off" align="middle">'); }
	    write('</td></tr>\n</table></td>');
	}
      %>
      </tr>
      </table>
      </td>
  </tr>	  
#endif

  COND_SHOW_BEGIN(_ps_cap_switch_simultan_serial1 && _ps_err_msg_serial1 == "")
  <tr><td align="center" class="bold" height="50" colspan="2">A_("Simultaneous Outlet Switch")</td></tr>
  <tr>
    <td colspan="2">
      VARIABLE(FMSZS(FV_ID_PC_PORT_VALUES), "<% write(power_entry_serial1_cnt); %>")
      <table>
      <table align="center">
        <tr>
          <% for (i = 0; i < power_entry_serial1_cnt; i++) {
	      _entry = getVarByIdx("power_entry_serial1", i);
	      _value = getVarByIdx("_ps_ipwr_port_values", i);
	      _delay = getVarByIdx("_ps_ipwr_port_delay", i);
	      if ( i == 8 ) {
		write('\n</tr><tr>\n');
	      } 
              write('<td>\n
                       <table class="cb_field">\n
                         <tr><td align="center" class="normal nowrap">' + _entry + '</td></tr>\n
			 <tr><td align="center" class="normal nowrap">(' + _delay + 's)</td></tr>\n
                         <tr><td align="center"><input type="checkbox" name="' + FMIS(FV_ID_PC_PORT_VALUES, i) + '" value="on" ');
	      if (_value == "on") { write("checked"); }
	        write('></td></tr>\n</table></td>');
	      }
          %>
        </tr>
	<tr>
          <td colspan="8" align="right">
	    SUBMIT_BUTTON(T_("Apply"), "apply", "apply_power_state_serial1", "")
          </td>
        </tr>
      </table>
    </td>
  </tr>
  
  <tr><td align="center" class="bold" height="50" colspan="2">A_("All Outlets")</td></tr>
  <tr>
	  <td align="center">SUBMIT_BUTTON(T_("Power On"), "poweron", "power_on_all_ports_serial1", "")</td>
	  <td align="center">SUBMIT_BUTTON(T_("Power Off"), "poweroff", "power_off_all_ports_serial1", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_switch_simultan_serial1 && _ps_err_msg_serial1 == "")

  COND_SHOW_BEGIN(power_device_serial1_cnt == 1)
    INVISIBLE_TABLE_ROW(VARIABLE(FMS(FV_ID_PC_POWER_DEVICE_0), "0"))
  COND_SHOW_END(power_device_serial1_cnt == 1)
  COND_SHOW_BEGIN(power_entry_serial1_cnt == 1)
    INVISIBLE_TABLE_ROW(VARIABLE(FMS(FV_ID_PC_POWER_PORT_0), "0"))
  COND_SHOW_END(power_entry_serial1_cnt == 1)
	       
  COND_SHOW_BEGIN(_ps_cap_state_serial1)
  <tr>
    <td align="left" class="normal">Current State:
      <% if ( current_power_state_serial1 != "" ) {
	     write(current_power_state_serial1); 
         } else {
	    write(T_("Unknown"));
         }
      %>
    </td>
    <td align="center">SUBMIT_BUTTON(T_("Get State"), "get_state", "get_state_serial1", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_state_serial1)

  COND_SHOW_BEGIN(_ps_cap_reset_serial1)
  <tr>
    <td align="center" colspan="2">SUBMIT_BUTTON(T_("Reset"), "reset", "reset_direct_serial1", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_reset_serial1)


	
  COND_SHOW_BEGIN(_ps_cap_switch_seq_serial1)
  <tr>
    <td align="center">SUBMIT_BUTTON(T_("Sequence On"), "seq_on", "switch_seq_on_serial1", "")</td>
    <td align="center">SUBMIT_BUTTON(T_("Sequence Off"), "seq_off", "switch_seq_off_serial1", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_switch_seq_serial1)
	
  COND_SHOW_END(power_entry_serial1_cnt >= 1 && power_device_serial1_cnt > 0)

  COND_SHOW_BEGIN(_ps_err_msg_serial2 != "")
    NOTICE_BEGIN(center)
    <% write(_ps_err_msg_serial2); %>
    NOTICE_END()
  COND_SHOW_END(_ps_err_msg_serial2 != "")

  COND_SHOW_BEGIN(power_entry_serial2_cnt >= 1 && power_device_serial2_cnt > 0)

  <tr>
    <td align="left" class="bold">A_("Serial Port 2:")</td>
    <td align="center" class="bold">
      <%
        writeEsc(_ps_name_serial2);
        pds2name = getVarByIdx("power_device_serial2", 0);
        if (power_device_serial2_cnt == 1 && pds2name != "") {
	    write(" - " + htmlEsc(pds2name));
        }
      %>
    </td>
  </tr>

  COND_SHOW_BEGIN(_serial2_intern_switch)
    #comment  Routing ATX signals via serial connector is never used with eric.
    #comment  Hence we have no ericxpa and thus no PSU adapter which could block
    #comment  our generated button presses.  => always show short/long press btns
    POWER_CONTROL_INTERN_BODY(1)
  COND_SHOW_END(_serial2_intern_switch)

  COND_SHOW_BEGIN(!_serial2_intern_switch)

  COND_SHOW_BEGIN(power_device_serial2_cnt > 1)
  <tr>
    <td align="left" class="normal">A_("Device:")</td>
    <td align="center">
      <select name=FMS(FV_ID_PC_POWER_DEVICE_1)>
	<% for (i = 0; i < power_device_serial2_cnt; i++) {
	       write('<option value="' + i + '"');
	       _entry = getVarByIdx("power_device_serial2", i);
	       if (i == current_power_device_serial2) { write(" selected"); }
	       write(">", htmlEsc(_entry), "\n");
           }
	%>   
      </select>
    </td>
  </tr>
  COND_SHOW_END(power_device_serial2_cnt > 1)

  COND_SHOW_BEGIN(power_entry_serial2_cnt > 1)
  <tr>
    <td align="left" class="normal">A_("Port:")</td>
    <td align="center">
      <select name="FMS(FV_ID_PC_POWER_PORT_1)">
	<% for (i = 0; i < power_entry_serial2_cnt; i++) {
	       write('<option value="' + i + '"');
	       _entry = getVarByIdx("power_entry_serial2", i);			   
	       if (i == current_power_entry_serial2) { write(" selected"); }
	       write(">", htmlEsc(_entry), "\n");
           }
        %>
      </select>
    </td>		
  </tr>
  COND_SHOW_END(power_entry_serial2_cnt > 1)
  
  COND_SHOW_BEGIN(power_entry_serial2_cnt == 1)
    INVISIBLE_TABLE_ROW(VARIABLE(FMS(FV_ID_PC_POWER_PORT_1), "0"))
  COND_SHOW_END(power_entry_serial2_cnt == 1)
  COND_SHOW_BEGIN(power_device_serial2_cnt == 1)
    INVISIBLE_TABLE_ROW(VARIABLE(FMS(FV_ID_PC_POWER_DEVICE_1), "0"))
  COND_SHOW_END(power_device_serial2_cnt == 1)

  COND_SHOW_BEGIN(_ps_cap_state_serial2)
  <tr>
     <td align="left" class="normal">A_("Current State:")
      <% if (current_power_state_serial2 != "") {
	     write(current_power_state_serial2); 
         } else {
	    write(T_("Unknown"));
         }
      %>
    </td>
    <td align="center">SUBMIT_BUTTON(T_("Get State"), "get_state", "get_state_serial2", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_state_serial2)

  COND_SHOW_BEGIN(_ps_cap_switch_serial2)
  <tr>
    <td align="center">SUBMIT_BUTTON(T_("Power On"), "poweron", "power_on_direct_serial2", "")</td>
    <td align="center">SUBMIT_BUTTON(T_("Power Off"), "poweroff", "power_off_direct_serial2", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_switch_serial2)

  COND_SHOW_BEGIN(_ps_cap_reset_serial2)
  <tr>
    <td align="center" colspan="2">SUBMIT_BUTTON(T_("Reset"), "reset", "reset_direct_serial2", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_reset_serial2)

  COND_SHOW_BEGIN(_ps_cap_switch_seq_serial2)
  <tr>
    <td align="center">SUBMIT_BUTTON(T_("Sequence On"), "seq_on", "switch_seq_on_serial2", "")</td>
    <td align="center">SUBMIT_BUTTON(T_("Sequence Off"), "seq_off", "switch_seq_off_serial2", "")</td>
  </tr>
  COND_SHOW_END(_ps_cap_switch_seq_serial2)

  COND_SHOW_END(!_serial2_intern_switch)

  COND_SHOW_END(power_entry_serial2_cnt >= 1 && power_device_serial2_cnt > 0)

DIALOGTABLE_END()

COND_SHOW_END(_show)

COND_SHOW_BEGIN(!_show)
  NOTICE_BEGIN(center)
	A_("External Power Control is not enabled. You should check the ") SERIAL_SETTINGS().
  NOTICE_END()
COND_SHOW_END(!_show)

COND_SHOW_BEGIN(power_device_serial1_cnt <= 0 && power_device_serial2_cnt <= 0)
  NOTICE_BEGIN(center)
	A_("There was no power switch detected. Please check ") INTERNAL_POWER_CONTROL_SETTINGS()
  NOTICE_END()
COND_SHOW_END(power_device_serial1_cnt <= 0 && power_device_serial2_cnt <= 0)

TMPL_END()

