#define __t__ TEMPLATE_SEC_SERVER_CERT_CSR
TMPL_BEGIN()

<% _csr_info = certGetCSRInfo();
   _disabled = aclHasPermission("security_s", "yes") != "yes"; %>

DIALOGTABLE_BEGIN()

  COND_SHOW_BEGIN(_csr_info == "" && !_disabled)
  
  <tr>
    <td class="settings_fieldname">A_("Common Name")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_CN) maxlength="128" size="32" value="<% writeEsc(FM(FV_ID_CERT_CN)); %>">
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Organizational Unit")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_OU) maxlength="64" size="32" value="<% writeEsc(FM(FV_ID_CERT_OU)); %>">
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Organization")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_O) maxlength="64" size="32" value="<% writeEsc(FM(FV_ID_CERT_O)); %>">
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Locality/City")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_L) maxlength="64" size="32" value="<% writeEsc(FM(FV_ID_CERT_L)); %>">
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("State/Province")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_ST) maxlength="64" size="32" value="<% writeEsc(FM(FV_ID_CERT_ST)); %>">
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Country (ISO Code)")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_C) maxlength="2" size="32" value="<% writeEsc(FM(FV_ID_CERT_C)); %>">
    </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Email")
    DIALOGTABLE_SPACER()
    <input type="text" name=FMS(FV_ID_CERT_EMAIL) maxlength="128" size="32" value="<% writeEsc(FM(FV_ID_CERT_EMAIL)); %>">
  </td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Challenge Password")
    DIALOGTABLE_SPACER()
    <input type="password" name=FMS(FV_ID_CERT_CHALLENGE) maxlength="20" size="32"></td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Confirm Challenge Password")
    DIALOGTABLE_SPACER()
    <input type="password" name="confirm_pw" maxlength="20" size="32"></td>
  </tr>
  <tr>
    <td class="settings_fieldname">A_("Key Length (bits)")
    DIALOGTABLE_SPACER()
      <select name=FMS(FV_ID_CERT_BITS)>
        <option value="1024" <% if (FM(FV_ID_CERT_BITS) == "1024") { write("selected"); } %>> "1024"
	<option value="2048" <% if (FM(FV_ID_CERT_BITS) == "2048") { write("selected"); } %>> "2048"
      </select>
      <%isDefault(FV_ID_CERT_BITS);%>
    </td>
  </tr>
  <tr><td class="buttons" colspan="2">
    SUBMIT_BUTTON(T_("Create"), "create", "create_csr", "")
    RESET_BUTTON<br>
    DEFAULT_MSG
  </td></tr>
  
  COND_SHOW_END(_csr_info == "" && !_disabled)
  COND_SHOW_BEGIN(_csr_info != "")
  
  <tr><td class="center bold" colspan="2">A_("The following CSR is pending:")</td></tr>
  <tr><td class="mono" colspan="2"><pre><% writeEsc(_csr_info); %></pre></td></tr>
  COND_SHOW_BEGIN(!_disabled)
  <tr> 	 
     <td class="center" colspan="2">
      SUBMIT_BUTTON(T_("Download"), "download", "download_csr", "")
      SMART_SUBMIT_BUTTON(T_("Delete"), "delete", "delete_csr", T_("Really Delete"), "r_delete", "really_delete_csr", _show_delete_csr_confirm, "")
     </td> 	 
  </tr>
  COND_SHOW_END(!_disabled)
  COND_SHOW_END(_csr_info != "")
DIALOGTABLE_END()
TMPL_END()
