#define __t__ TEMPLATE_UM_GROUPS

TMPL_BEGIN()
<% _allow_change = aclHasPermission("um", "yes") == "yes";
   umInitGroupAndTargetGroup();
   umInitAllUsers(); 
   umInitAllGroups();
   _form_create = umGroupFormState() == "create";
%>
DIALOGTABLE_BEGIN()
#if defined(PP_FEAT_RARITAN_STYLE_UM_PAGES)
  <tr>
    <td class="settings_fieldname">A_("Group Name")<%ShowRequiredAsterisk();%>
    DIALOGTABLE_SPACER()
      <% if (_form_create) {
            _value = FM(FV_ID_GR_NEW_GROUP);
         }
         else {
            _value = FM(FV_ID_GR_GROUP);
         }
         if (_allow_change) {
            writePure('<input ', isDisabledStr(FV_ID_GR_NEW_GROUP), ' type="text" name=', FMS(FV_ID_GR_NEW_GROUP), ' value="', _value, '" size="32" maxlength="32">');
         }
         else {
            writeEsc(_value);
         }
      %>
      <input type="hidden" name=FMS(FV_ID_GR_GROUP) value="<% writeEsc(FM(FV_ID_GR_GROUP)); %>" size="32" maxlength="32">
    </td>
  </tr>
#else /* !PP_FEAT_RARITAN_STYLE_UM_PAGES */
  <tr>
    <td class="settings_fieldname">A_("Existing groups")
    DIALOGTABLE_SPACER()
      <select name=FMS(FV_ID_GR_GROUP) onchange="getElement('name', 'action_' + 'lookup_group', 0).click()">
        <option value = ""> A_("--- select ---")
        <% for (i = 0; i < FMSZ(FV_ID_GR_GROUP); i++) {
#comment only show non individual groups
               _group = FMI(FV_ID_GR_GROUP, i);
               if (! umGroupIsIndividual(_group)) {
                   if (FM(FV_ID_GR_GROUP) == _group) { _sel = "selected"; } 
                   else { _sel = ""; }
                   write('<option', _sel, '>', htmlEsc(_group), '\n');
               }
           }
        %>
      </select>
      SUBMIT_BUTTON(T_("Lookup"), "lookup", "lookup_group", "")
    </td>
  </tr>
  COND_SHOW_BEGIN(_allow_change)
  <tr>
    <td class="settings_fieldname">A_("New group name")
    DIALOGTABLE_SPACER()
      <input <%isDisabled(FV_ID_GR_NEW_GROUP);%> type="text" name=FMS(FV_ID_GR_NEW_GROUP)
	     value="<% writeEsc(FM(FV_ID_GR_NEW_GROUP)); %>" size="32" maxlength="32">
    </td>
  </tr>
  <tr>
  <tr>
#if defined(PP_FEAT_RARITAN_DESIGN)
      <td class="buttons">
#else /* !PP_FEAT_RARITAN_DESIGN */
      <td class="normal center" colspan="2">
#endif /* !PP_FEAT_RARITAN_DESIGN */
          SUBMIT_BUTTON(T_("Create"), "create", "create_group", "")
	  SUBMIT_BUTTON(T_("Modify"), "modify", "modify_group", "")
	  SUBMIT_BUTTON(T_("Copy"),   "copy",   "copy_group", "")
	  SUBMIT_BUTTON(T_("Delete"), "delete", "delete_group", "")
          <% _group_id = FM(FV_ID_GR_GROUP_ID);
             if (_group_id != "" && _group_id <= 2) {
                 write('<script type="text/javascript">',
                       'getElement("name", "action_create_group", 0).disabled = true;',
                       'getElement("name", "action_modify_group", 0).disabled = true;',
                       'getElement("name", "action_delete_group", 0).disabled = true;',
                       '</script>');
             } %>
    </td>
  </tr>      
  COND_SHOW_BEGIN(!isEmpty(FM(FV_ID_GR_GROUP)) && FM(FV_ID_GR_GROUP) != getGroupName(0))
    <tr></tr>
    <tr>
      <td>
        <% 
          writef(T_("Click <a href=\"acl.asp?__target_group__=%s\">here</a> to modify group permissions."), 
            FM(FV_ID_GR_GROUP));
        %>
      </td>
    </tr>
    <tr>
      <td>
        NOTICE_BEGIN(center)
          A_("Please ensure you have applied all changes to group before modifying permissions or changes will be lost!")
        NOTICE_END()
      </td>
    </tr>
  COND_SHOW_END(!isEmpty(FM(FV_ID_GR_GROUP)) && FM(FV_ID_GR_GROUP) != getGroupName(0))
  COND_SHOW_END(_allow_change)
#endif /* !PP_FEAT_RARITAN_STYLE_UM_PAGES */
DIALOGTABLE_END()
TMPL_END()
