#define __t__ TEMPLATE_VFLOPPY_INTERN
TMPL_BEGIN()

<% 
   _free_drives = 0;
   for (i = 0; i < PP_FEAT_USB_MASS_STORAGE_NO; i++) {
      if (getVFloppyInfo(i, "type") == "none") {
         _free_drives = _free_drives + 1;
      }
   }
   
   _vfloppy_type  = getVFloppyInfo("type");
   _vfloppy_name  = getVFloppyInfo("name");
   do_disable = "";
   if (_free_drives == 0) {
       do_disable = N_(" disabled");
   }
%>

DIALOGTABLE_BEGIN()
  <tr>
    <td class="notice" colspan="2">
       A_("This option allows you to upload a binary image (e.g. example.img)<br>with a maximum size of 1.44MB to the ")
       <% writeEsc(boardName()); %>
       A_(".<br>This image will be emulated to the host as USB device.<br><br>")
    </td>
  </tr>
#if PP_FEAT_USB_MASS_STORAGE_NO == 1
  <input type="hidden" name="vfloppy_ms_index" value="0">
#else
  <tr>
    <td class="settings_fieldname">A_("Virtual Drive")
    DIALOGTABLE_SPACER()
      <select name="vfloppy_ms_index"<% write(do_disable); %>>
      <% 
         _sel = 0;
         for (i = 0; i < PP_FEAT_USB_MASS_STORAGE_NO; i++) {
            if (getVFloppyInfo(i, "type") == "none" || getVFloppyInfo(i, "type") == "file") {
               write('<option value="' + i + '"');
               if (_sel == 0) {
                  write(' selected');
                  _sel = 1;
               }
               write('>', T_("Drive") , (i + 1));
            }
         }
      %>
      </select>
    </td>
  </tr>
#endif
  <tr>
    <td class="settings_fieldname">A_("Floppy Image File")
    DIALOGTABLE_SPACER()
    <input type="file" name="vfloppy_file"<% write(do_disable); %>></td>
  </tr>
 COND_SHOW_BEGIN(_free_drives == 0)
  <tr>
    <td class="center" colspan="2">
      NOTICE_BEGIN()
	A_("You must remove")
#if PP_FEAT_USB_MASS_STORAGE_NO == 1
	A_("the current")
#else
	A_("at least one")
#endif
        A_("virtual disk to install a floppy image.")
      NOTICE_END()
    </td>
  </tr>
 COND_SHOW_END(_free_drives == 0)
 COND_SHOW_BEGIN(_free_drives != 0)
  <tr>
    <td  class="buttons" colspan="2">
	SUBMIT_BUTTON(T_("Upload"), "upload", "vfloppy_upload", "")
    </td>
  </tr>
 COND_SHOW_END(_free_drives != 0)
DIALOGTABLE_END()
TMPL_END()
