/*--------------------------------------------------------------------------------

	CC.h

	Copyright (c) 2003, Raritan Computer, Inc.

	header file for CC.cpp

--------------------------------------------------------------------------------*/

#ifndef _CC_H_
#define	_CC_H_

#include "pp/RDM_Local_Notify.h"
#include "pp/timer.h"
#include "pp/CCUserObject.h"
#include "pp/UDPListener.h"

#include <openssl/ssl.h>
#include <openssl/rsa.h>       /* SSLeay stuff */
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/err.h>
#include <openssl/rc4.h>
#include <openssl/evp.h>


//----------------------------------------
//				Equates
//----------------------------------------


//----------------------------------------
//				Data Types
//----------------------------------------

typedef	struct
{
	int		enable;						// !0 = CC is enabled
	char	clusterID[RDM_MAX_CLUSTER];	// The CC cluster ID
	char	ccUser[RDM_MAX_USER_NAME];	// CC Login user name
	char	ccPassword[RDM_MAX_USER_NAME];// Password
	int		ipAddress;					// IP Address of IP reach
	int		ipPort;						// Port to send events to
	int		heartbeatTime;				// # of seconds between heartbeats
	char	eventKey[RDM_MAX_KEY];		// Binary key
	char *	pEventKeyBase64;			// Base64 during parsing
	int		ccTimeout;					// CC Timeout period
} CC_CONFIG;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CCommandCenter : public CRDM_Local_Notify, public CTimer, public CUDPHandler
{
public:

	CCommandCenter( CRDM *pRDM );
	virtual ~CCommandCenter();

	CUserObject *						// Returns a user object ptr if authenticated
	Authenticate
	(
		const char	*pUserName,				// The user name
		const char	*pPassword				// The password
	);

	void
	SetupEventKey
	(
		const char	*pKey
	);

	void
	EncryptMessage
	(
		char	*pData,					// Data to Encrypt/Decrypt
		int		length					// # of bytes
	);

	int
	SetupSocket
	(
		int	ipAddress,
		int	ipPort
	);

	void
	Notify
	(
		RDM_EVENT	*pEvent				// The event
	);

	int
	SendCCUDPMessage
	(
		const char	*pXMLText				// The XML text of the message
	);

	void 
	TimerProc
	(
	);

	int
	Retry
	(
		int		start,					// Starting serialNo
		int		count					// # of messages
	);

	int									// !0 message was from CC
	ProcessCCMessage
	(
		const char	*pData,					// The message data
		int		length
	);

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Virtual call back functin to handle UDP message.
	 * 
	 *  @param	ipAddress		The client IP address
	 *  @param	pData			The data received
	 * 	@param	count			# of bytes
	 *	@return					true = message was handled, false = call next handler
	 */

	virtual bool ReceiveUDPMessage( CUDPListener * pUDP, int ipAddress, char * pData, int count );

	inline
	int
	IsEnabled() { return config.enable; }

	inline
	int
	IsHeartBeatGood() { return heartBeatGood; }

	inline
	char *
	GetClusterID() { return config.clusterID; }

	inline
	int
	GetIPAddress() { return config.ipAddress; }

	void
	Timeout
	(
	);

    void
    InitializeManagement
    (
    );

    void
    StopManagement
    (
    );

private:
/*
	void
    ResetPathStatus
	(
	);

	void
    ResetPortStatus
	(
	);

	void
    ReleaseThisResourceAndSession
	(
        char * resourceID
	);

	void
    ReleaseResourceAndSession
    (
    );
*/

protected:

	CRDM			*	rdm;				// Ptr to the RDM object

	CC_CONFIG			config;			// CC configuration Data from Database
	SOCKET				udpSocket;		// UDP Socket
	struct	sockaddr_in	socketAddress;// UDP Address

	int					isEncrypted;	// !0 if CC UDP messages are encrypted
	RC4_KEY				eventKey;		// The initialized RC4 key

	// Retry data

	int					msgSent;		// How many msgs were sent since last heart beat
	int					retryPending;	// !0 if there is a pending retry

	// Timeout

	CTimer				timeoutTimer;	// Second timer used to measure the CC timeout period
	int					heartBeatGood;	// !0 when we have received heartBeats from CC
	int					hearBeatCount;	// CC Heart beat counter
};

#endif // _CC_H_


