/*--------------------------------------------------------------------------------

	Certificate.cpp

	Copyright (c) 2000, Raritan Computer, Inc.

	Certificate utility functions

--------------------------------------------------------------------------------*/

#define		DBTYPE	DBCOMPRESS

#include <stdio.h>

#include <pp/OS_Port.h>
#include <pp/Certificate.h>

#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/bn.h>
#include <openssl/rsa.h>
#include <openssl/evp.h>
#include <openssl/x509.h>
#include <openssl/x509v3.h>
#include <openssl/objects.h>
#include <openssl/pem.h>
#include <openssl/rand.h>
#include <openssl/conf.h>

//----------------------------------------
//				Equates
//----------------------------------------

#define SECTION		"req"

#define BITS		"default_bits"
#define KEYFILE		"default_keyfile"
#define PROMPT		"prompt"
#define DISTINGUISHED_NAME	"distinguished_name"
#define ATTRIBUTES	"attributes"
#define V3_EXTENSIONS	"x509_extensions"
#define REQ_EXTENSIONS	"req_extensions"
#define STRING_MASK	"string_mask"

#define	RANDOM_DATA_SIZE	1024

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

/* not used yet */
#if 0
static void GenRSAProc (int p, int n, void *arg);
#endif
static int add_oid_section(LHASH *conf);
static int make_REQ(X509_REQ *req,EVP_PKEY *pkey,int attribs);

//----------------------------------------
//				Static Data
//----------------------------------------

static LHASH *req_conf=NULL;

//----------------------------------------
//				Functions
//----------------------------------------

//--------------------------------------------------------------------------------
//
	BOOL
	CreatePrivateKeyFile
	(
		const char *pFileName
	)
//
//	Create private key file.
//
//--------------------------------------------------------------------------------
{
	BIGNUM			*bn = NULL;
	RSA			*rsa = NULL;
	BYTE		random[RANDOM_DATA_SIZE];
	BIO			*out=NULL;
	EVP_CIPHER	*enc=NULL;
	char		*passout = NULL;
	BOOL		bOk = FALSE;
	int			x;

	// Get some random data

	for (x=0;x< (int) RANDOM_DATA_SIZE; x++)
		random[x] = (BYTE) ((x * OS_GetTickCount()) ^ (OS_GetTickCount() >> 8) ^ (OS_GetTickCount() >> 16) );

	RAND_seed( &random, RANDOM_DATA_SIZE );

	// Create an RSA private key

#ifndef X86
	if (!((bn = BN_new()) != NULL
		    && BN_set_word(bn, RSA_F4)
		    && (rsa = RSA_new()) != NULL
		    && RSA_generate_key_ex(rsa, 1024, bn, NULL))) {
	    goto err;
	}
#else
	rsa = RSA_generate_key(1024,0x10001,GenRSAProc,0);
#endif

	// Setup the BIO for writting

	if ((out=BIO_new(BIO_s_file())) == NULL)
	{
		goto err;
	}

	{
	    /* Broken openssl API */
	    union {
		const char * pFileNameConst;
		char * pFileName;
	    } kludge = { pFileName };
	    if (BIO_write_filename(out, kludge.pFileName) <= 0) {
		goto err;
	    }
	}

	// Write the PEM file

	if (!PEM_write_bio_RSAPrivateKey(out,rsa,enc,NULL,0,NULL, passout))
		goto err;

	bOk = TRUE;

	// Clean up and exit.
err:
	if (rsa != NULL) RSA_free(rsa);
	if (bn != NULL) BN_free(bn);
	if (out != NULL) BIO_free(out);

	return bOk;
}

//--------------------------------------------------------------------------------
//
	BOOL
	CreateCertConfigFile
	(
		const char *pFileName
	)
//
//	Create certficate config file.
//
//--------------------------------------------------------------------------------
{
	BOOL	bOk = FALSE;
	FILE *	fp;
	DWORD	count;
	char	text[] =	"[ req ]\n"
						"default_bits           = 1024\n"
						"default_keyfile        = keyx.pem\n"
						"distinguished_name     = req_distinguished_name\n"
						"attributes             = req_attributes\n"
						"prompt                 = no\n"
						"output_password        = mypass\n"
						"\n"
						"[ req_distinguished_name ]\n"
						"C                      = US\n"
						"ST                     = New Jersey\n"
						"L                      = Somerset\n"
						"O                      = Raritan\n"
						"OU                     = TeleReach\n"
						"CN                     = TeleReachServer\n"
						"emailAddress           = tech@raritan.com\n"
						"\n"
						"[ req_attributes ]\n"
						"challengePassword              = A challenge password\n"
						"\n";

	fp = fopen(pFileName,"wb");

	if (fp != NULL)
	{
		count = fwrite( &text, sizeof(text), 1, fp );

		bOk = count == 1;

		bOk &= fclose(fp) == 0;
	}

	return bOk;
}

//--------------------------------------------------------------------------------
//
	BOOL
	CreateCertificateFile
	(
		const char *pKeyFileName,
		const char *pCertConfigFileName,
		const char *pCertificateFileName
	)
//
//	Create certificate file.
//
//--------------------------------------------------------------------------------
{
	int ex=1,x509=0,days=30;
	X509 *x509ss=NULL;
	X509_REQ *req=NULL;
	EVP_PKEY *pkey=NULL;
	int i,newreq=0;
	BIO *in=NULL,*out=NULL;
	const char *outfile,*keyout=NULL;
	const EVP_CIPHER *cipher=NULL;
	char *passin = NULL; // , *passout = NULL;
	char *p;
	const EVP_MD *digest=EVP_md5();
	long errline;

	cipher=EVP_des_ede3_cbc();	// ???

	newreq=1;
	x509=1000;
	outfile = pCertificateFileName;


	// Load the config file

	req_conf=CONF_load(NULL,pCertConfigFileName,&errline);
	if (req_conf == NULL)
	{
		//DBLog(("error on line %ld of %s\n",errline,pCertConfigFileName));
		goto end;
	}

	// Get the oid info

	p=CONF_get_string(req_conf,NULL,"oid_file");
	if (p != NULL)
		{
		BIO *oid_bio;

		oid_bio=BIO_new_file(p,"r");
		if (oid_bio == NULL) 
			{
			//DBLog(("problems opening %s for extra oid's\n",p));
			goto end;
			}
		else
			{
			OBJ_create_objects(oid_bio);
			BIO_free(oid_bio);
			}
		}

	if(!add_oid_section(req_conf)) goto end;

	// Create the input/output BIOs

	in=BIO_new(BIO_s_file());
	out=BIO_new(BIO_s_file());

	if ((in == NULL) || (out == NULL))
		goto end;

	// Read in the Key file

	{
	    /* Broken openssl API */
	    union {
		const char * pKeyFileNameConst;
		char * pKeyFileName;
	    } kludge = { pKeyFileName };
	    if (BIO_read_filename(in,kludge.pKeyFileName) <= 0) {
		perror(pKeyFileName);
		goto end;
	    }
	}

	pkey=PEM_read_bio_PrivateKey(in,NULL,NULL,passin);

	if (pkey == NULL)
		{
		//DBLog(("unable to load Private key\n"));
		goto end;
		}


	// ??? Rand File ???

//hack	app_RAND_write_file(randfile, bio_err); // ???

	// Process the key output file
/*
	if (keyout == NULL) // ???
		keyout=CONF_get_string(req_conf,SECTION,KEYFILE);

	if (keyout == NULL)
		{
		DBLog(("writing new private key to stdout\n"));
		BIO_set_fp(out,stdout,BIO_NOCLOSE);
		}
	else
		{
		DBLog(("writing new private key to '%s'\n",keyout));
		if (BIO_write_filename(out,keyout) <= 0)
			{
			perror(keyout);
			goto end;
			}
		}
*/
	// Get the cipher
/*
	p=CONF_get_string(req_conf,SECTION,"encrypt_rsa_key");
	if (p == NULL)
		p=CONF_get_string(req_conf,SECTION,"encrypt_key");
	if ((p != NULL) && (strcmp(p,"no") == 0))
		cipher=NULL;
	
	if (!PEM_write_bio_PrivateKey(out,pkey,cipher,NULL,0,NULL,passout))
	{
		goto end;
	}

	DBLog(("-----\n"));
*/

	// hmmm

#ifndef NO_DSA
	if (pkey->type == EVP_PKEY_DSA)
		digest=EVP_dss1();
#endif

	if (pkey == NULL)
		{
		//DBLog(("you need to specify a private key\n"));
		goto end;
		}

	if (req == NULL)
		{
		req=X509_REQ_new();
		if (req == NULL)
			{
			goto end;
			}

		i=make_REQ(req,pkey,!x509);

		if (!i)
			{
			//DBLog(("problems making Certificate Request\n"));
			goto end;
			}
		}

	// Setup the certificate data

	if (x509)
	{
		EVP_PKEY *tmppkey;
		X509V3_CTX ext_ctx;
		if ((x509ss=X509_new()) == NULL) goto end;

		/* Set version to V3 */
		if(!X509_set_version(x509ss, 2)) goto end;
		ASN1_INTEGER_set(X509_get_serialNumber(x509ss),0L);

		X509_set_issuer_name(x509ss, X509_REQ_get_subject_name(req));	// was req instead of NULL
		X509_gmtime_adj(X509_get_notBefore(x509ss),0);
		X509_gmtime_adj(X509_get_notAfter(x509ss),
			(long)60*60*24*days);
		X509_set_subject_name(x509ss, X509_REQ_get_subject_name(req));	// was req instead of NULL
		tmppkey = X509_REQ_get_pubkey(req);	// was req instead of NULL
		X509_set_pubkey(x509ss,tmppkey);
		EVP_PKEY_free(tmppkey);

		/* Set up V3 context struct */

		X509V3_set_ctx(&ext_ctx, x509ss, x509ss, NULL, NULL, 0);
		X509V3_set_conf_lhash(&ext_ctx, req_conf);


		if (!(i=X509_sign(x509ss,pkey,digest)))
			goto end;
	}


	if (outfile == NULL)
		BIO_set_fp(out,stdout,BIO_NOCLOSE);
	else
	{
		{
		    /* Broken openssl API */
		    union {
			const char * outfileConst;
			char * outfile;
		    } kludge = { outfile };
		    if ((keyout != NULL) && (strcmp(outfile,keyout) == 0))
			i=(int)BIO_append_filename(out, kludge.outfile);
		    else
			i=(int)BIO_write_filename(out, kludge.outfile);
		}
		if (!i)
			{
			perror(outfile);
			goto end;
			}
	}


	if (x509 && (x509ss != NULL))
	{
		i=PEM_write_bio_X509(out,x509ss);
		if (!i)
		{
			//DBLog(("unable to write X509 certificate\n"));
			goto end;
		}
	}
	ex=0;

end:


	if (ex)
	{
		//DBLog(("Req Error\n"));
	}

	BIO_free(in);
	BIO_free(out);
	EVP_PKEY_free(pkey);
	X509_REQ_free(req);
	X509_free(x509ss);
	OBJ_cleanup();

	return ex == 0;
	}

static int add_oid_section(LHASH *conf)
{	
	char *p;
	STACK_OF(CONF_VALUE) *sktmp;
	CONF_VALUE *cnf;
	int i;
	if(!(p=CONF_get_string(conf,NULL,"oid_section"))) return 1;
	if(!(sktmp = CONF_get_section(conf, p))) {
		//DBLog(( "problem loading oid section %s\n", p));
		return 0;
	}
	for(i = 0; i < sk_CONF_VALUE_num(sktmp); i++) {
		cnf = sk_CONF_VALUE_value(sktmp, i);
		if(OBJ_create(cnf->value, cnf->name, cnf->name) == NID_undef) {
			//DBLog(( "problem creating object %s=%s\n", cnf->name, cnf->value));
			return 0;
		}
	}
	return 1;
}

static int auto_info(X509_REQ *req, STACK_OF(CONF_VALUE) *dn_sk,
			STACK_OF(CONF_VALUE) *attr_sk, int attribs)
	{
	int i;
	char *p,*q;
	char *type;
	CONF_VALUE *v;
	X509_NAME *subj;

	subj = X509_REQ_get_subject_name(req);

	for (i = 0; i < sk_CONF_VALUE_num(dn_sk); i++)
		{
		v=sk_CONF_VALUE_value(dn_sk,i);
		p=q=NULL;
		type=v->name;
		/* Skip past any leading X. X: X, etc to allow for
		 * multiple instances 
		 */
		for(p = v->name; *p ; p++) 
			if ((*p == ':') || (*p == ',') || (*p == '.')) {
				p++;
				if(*p) type = p;
				break;
			}
		if (!X509_NAME_add_entry_by_txt(subj,type, MBSTRING_ASC,
				(unsigned char *) v->value,-1,-1,0)) return 0;

		}

		if (!X509_NAME_entry_count(subj))
			{
			//DBLog(("error, no objects specified in config file\n"));
			return 0;
			}
		if (attribs)
			{
			for (i = 0; i < sk_CONF_VALUE_num(attr_sk); i++)
				{
				v=sk_CONF_VALUE_value(attr_sk,i);
				if(!X509_REQ_add1_attr_by_txt(req, v->name, MBSTRING_ASC,
					(unsigned char *)v->value, -1)) return 0;
				}
			}
	return 1;
	}

static int make_REQ(X509_REQ *req, EVP_PKEY *pkey, int attribs)
	{
	int ret=0,i=0;
	char no_prompt = 0;
	STACK_OF(CONF_VALUE) *dn_sk, *attr_sk = NULL;
	char *tmp, *dn_sect,*attr_sect;

	tmp=CONF_get_string(req_conf,SECTION,PROMPT);
	if((tmp != NULL) && !strcmp(tmp, "no")) no_prompt = 1;

	dn_sect=CONF_get_string(req_conf,SECTION,DISTINGUISHED_NAME);
	if (dn_sect == NULL)
		{
		//DBLog(("unable to find '%s' in config\n",DISTINGUISHED_NAME));
		goto err;
		}
	dn_sk=CONF_get_section(req_conf,dn_sect);
	if (dn_sk == NULL)
		{
		//DBLog(("unable to get '%s' section\n",dn_sect));
		goto err;
		}

	attr_sect=CONF_get_string(req_conf,SECTION,ATTRIBUTES);
	if (attr_sect == NULL)
		attr_sk=NULL;
	else
		{
		attr_sk=CONF_get_section(req_conf,attr_sect);
		if (attr_sk == NULL)
			{
			//DBLog(("unable to get '%s' section\n",attr_sect));
			goto err;
			}
		}

	/* setup version number */
	if (!X509_REQ_set_version(req,0L)) goto err; /* version 1 */

	if(no_prompt) i = auto_info(req, dn_sk, attr_sk, attribs);
//	else i = prompt_info(req, dn_sk, dn_sect, attr_sk, attr_sect, attribs);
	if(!i) goto err;

	X509_REQ_set_pubkey(req,pkey);

	ret=1;
err:
	return(ret);
	}

/* not used yet */
#if 0
//--------------------------------------------------------------------------------
//
	static void
	GenRSAProc
	(
		int	/* p */,
		int	/* n */,
		void *  /* arg */
	)
//
//	Callback from RSA_generate_key() - do nothing
//
//--------------------------------------------------------------------------------
{
}
#endif

//--------------------------------------------------------------------------------
//
	BOOL
	DestroyFile
	(
		const char *pFileName
	)
//
//	Writes garbage data over a file and then deletes it
//
//--------------------------------------------------------------------------------
{
	BOOL	bOk = FALSE;
	FILE *	fp;
	DWORD	count,temp;
	BYTE	random[RANDOM_DATA_SIZE];
	int		x;

	fp = fopen(pFileName,"a+b");

	if (fp != NULL)
	{
		count = ftell(fp);
		fseek(fp,0,SEEK_SET);
		do
		{
			for (x=0;x< (int) RANDOM_DATA_SIZE; x++)
				random[x] = (BYTE) (x * OS_GetTickCount());
			if (count > RANDOM_DATA_SIZE)
				temp = RANDOM_DATA_SIZE;
			else
				temp = count;

			fwrite( &random, temp, 1, fp );

			count-=temp;

		} while (count);

		fclose(fp);

		remove( pFileName );

		bOk = TRUE;
	}

	return bOk;
}
