/*-------------------------------------------------------------------------------

	RDM_Local_Notify.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Protocol Local Notification Subscription class (CRDM_Local_Notify)

	This class is used by other TRServer components to subscribe to notifications.
	The notifications are sent directly to a call back function. The event
	data is passed as parameters to the call back function.

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	"pp/RDM_Local_Notify.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CRDM_Local_Notify
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CRDM_Local_Notify::CRDM_Local_Notify
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	pCallBack = NULL;
}

//--------------------------------------------------------------------------------
//
	CRDM_Local_Notify::~CRDM_Local_Notify
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
}

//--------------------------------------------------------------------------------
//
	void
	CRDM_Local_Notify::SetCallBack
	(
		CRDM_Local_CallBack	*pFunc,		// Ptr to the function
		void *			pNewUserData	// Ptr to user data passed back to callback func
	)
//
//	Registers a callback function for this local notification subscription.
//
//------------------------------------------------------------------------------//
{
	pUserData = pNewUserData;
	pCallBack = pFunc;
}

//--------------------------------------------------------------------------------
//
	void
	CRDM_Local_Notify::Notify
	(
		RDM_EVENT	*pEvent				// The event
	)
//
//	Sends a notification to this subscription
//
//------------------------------------------------------------------------------//
{
	if (pCallBack != NULL)
		(pCallBack)(pUserData, pEvent);
}
