/*--------------------------------------------------------------------------

	SessionReferralObject.cpp

	Copyright (c) 2004, Raritan Computer, Inc.

	Raritan Device Manager Protocol Session Referral Object class (CSessionReferralObject)

	This object is attached to referral sessions to hold them active until 
	the session is used. It also offers timeout service for referral session
	that are never used.

	Call the Global function AttatchSessionReferralObject() to attach a new
	Referral object to a new session. Call RemoveSessionReferralObject() will
	remove the object from the session and cancel the timer.

---------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<pp/syms.h>
#include	<pp/Session.h>
#include	<pp/SessionReferralObject.h>
#include	<pp/timer.h>

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//
	CSessionReferralObject *			// Object Ptr or NULL
	AttatchSessionReferralObject
	(
		CSession *	pSession,			// The session to attach to
		int			timeout				// The timeout period in ms, 0 = NO timeout
	)
//
//	Creates a referral session object and attaches it to the session.
//	If timeout is not 0, then it specifies the # of ms until the timeout timer expires.
//	When the timer expires, the session is released. If nothing else is attached
//	to the session, it will be closed.
//
//------------------------------------------------------------------------------//
{
	return new CSessionReferralObject( pSession, timeout );
}

//--------------------------------------------------------------------------------
//
	void
	RemoveSessionReferralObject
	(
		CSession *	pSession			// The session to attach to
	)
//
//	Removes the referral session object from a session
//	There is no harm in calling this function twice or calling it for sessions
//	that do not have referral objects.
//
//------------------------------------------------------------------------------//
{
	CSessionObject * p;

	p = pSession->EnumObjectByClass( SESSION_REFERRAL_CLASS, NULL );
	if (p != NULL)
	{
		pSession->RemoveSessionObject( p );
		delete p;
	}
}

//---------------------------------------------------------------------------
//							CSessionReferralObject
//---------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CSessionReferralObject::CSessionReferralObject
	(
		CSession *	pNewSession,			// The session to attach to
		int			timeout				// The timeout period in ms, 0 = NO timeout
	) : CSessionObject(SESSION_REFERRAL_CLASS)
//
//	Init the object
//
//------------------------------------------------------------------------------//
{
	// Attach to the session
	if (pNewSession != NULL)
	{
		pSession = pNewSession;
		pSession->Aquire();
		aquired = 1;
		pSession->AddSessionObject( this );
//		pSession->Event( pSession, SESSION_EVENT_CONNECT, (void*)"Referral" );
	}
	else
	{
		aquired = 0;
		pSession = NULL;
	}

	// Start the timeout timer
	if (timeout != 0)
	{
		SetCTimer(timeout,1);
		StartCTimer();
	}
}

//--------------------------------------------------------------------------------
//
	CSessionReferralObject::~CSessionReferralObject
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	Release();
}

//--------------------------------------------------------------------------------
//
	void
	CSessionReferralObject::Event
	(
		CSession	* NOTUSED(pUserSession),	// The session in question...
		int		event,				// Which SESSION_EVENT_ code
		const void	* NOTUSED(pData)		// Data associated with the event
	)
//
//	Handles session events.
//
//------------------------------------------------------------------------------//
{
	if (event == SESSION_EVENT_CLOSE || event == SESSION_EVENT_CONNECT)
		Release();
}

//--------------------------------------------------------------------------------
//
	void
	CSessionReferralObject::TimerProc
	(
	)
//
//	Timer expire
//
//------------------------------------------------------------------------------//
{
	StopCTimer();
	if (pSession != NULL && aquired)
	{
		pSession->Close();
	}
}

//--------------------------------------------------------------------------------
//
	void
	CSessionReferralObject::Release
	(
	)
//
//	Release the sesson
//
//------------------------------------------------------------------------------//
{
	StopCTimer();
	if (pSession != NULL && aquired)
	{
		aquired = 0;
		pSession->Release();
	}
}
