/**	
 *	@file	RDM_DDA_Path.h
 *	@brief	Public Device Data API (DDA) for Paths
 *
 *	
 */

#ifndef _RDM_DDA_Path_h_
#define _RDM_DDA_Path_h_

#include "pp/RDM_BranchManager.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

 class CRDM;
 class CDDA_Port;

/*----------------------------------------
 *	Path Class
 *--------------------------------------*/

class CDDA_Path : public CRDM_BranchManager
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Constructor for a path
	 *
	 *	Create a new path node in the database.
	 *
	 *	@param	pRDM			Ptr to RDM object
	 *	@param	pParentPort		Ptr to the parent device object
	 *  @param	pID				ID of the path
	 *	@param	index			path index starting from 0
	 */

	CDDA_Path ( CRDM * pRDM, CDDA_Port *pParentPort, const char *pID, int index );

	~CDDA_Path();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	Functions to change port attributes.
	 *  Must call BeginUpdate() before changing attributes and EndUpdate()
	 *  when finished changing attributes.
	 *  BeginUpdate() locks the database and EndUpdate() unlocks the database
	 *  and then send the RDM events
	 * 
	 */

	void BeginUpdate();
	void SetStatus( int status );
	void SetUserPort( int userPort );
	void SetLocalAccess( int access );
	void PriorityMode( int mode );
	void EndUpdate();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	Private Data
	 * 
	 */

private:
	CRDM	*	pRDM;				///< Ptr to the RDM object
	int			sendEvents;			///< !0 = Send events for changes
	char		id[RDM_MAX_ID];		///< Our ID
	int			sendChgEvent;		///< !0 = we need to send a device change event
	int			sendStatusEvent;	///< !0 = we need to send a status event
	int			okToSendEvents;		///< !0 = it's ok to send events
};

#endif // _RDM_DDA_Path_h_


