/*-------------------------------------------------------------------------------

	RDM_DDA_Utility.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Utility functions useful to DDA modules.

--------------------------------------------------------------------------------*/

#ifndef _RDM_DDA_Utility_h_
#define _RDM_DDA_Utility_h_

#include	"pp/RDM.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	int									// <0 = error (port was not found)
	DDA_UpdatePortStatus
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,				// ID of the port
		int		status				// Port status (0,1,2)
	);

	int									// <0 = error (port was not found)
	DDA_UpdatePathStatus
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,				// ID of the path
		int		status				// Port status (0,1,2)
	);

	void
	DDA_NotifyWithName
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pElement,			// Element name
		const char	*pData,				// Name of the user or group
		const char	*pID,				// The ID to send to
		int		eventID				// The event ID
	);

	void
	DDA_Notify_UserName
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,				// The ID to send to
		int		eventID,			// The event ID
		const char	*pName				// Name of the user
	);

	void
	DDA_Notify_GroupName
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,				// The ID to send to
		int		eventID,			// The event ID
		const char	*pName				// Name of the group
	);

	void
	DDA_Notify_System
	(
		CRDM	*pRDM,					// Ptr to RDM
		int		eventID					// The event ID
	);

	void
	DDA_Notify_System
	(
		CRDM	*pRDM,					// Ptr to RDM
		int		evenID,				// The event ID
		const char	*mode				// Reset value
	);

	void
	DDA_Notify_Text
	(
		CRDM	*pRDM,					// Ptr to RDM
		int		eventID,			// The event ID
		const char	*pText				// Name of the group
	);

	void
	DDA_Notify_Net
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pSessionID,			// The session ID
		int		eventID,			// The event ID
		const char	*pName,				// Name of the group
		DWORD	ipAddress				// The IP Address
	);

	void
	DDA_Notify_ID
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,				// The ID to send to
		int		eventID				// The event ID
	);

	void
	DDA_Notify_Error
	(
		CRDM	*pRDM,					// Ptr to RDM
		int		eventID,			// The event ID
		DWORD	errorCode,				// The error code
		const char	*pFileName,				// File name the error occurred in
		DWORD	lineNo					// Line number in the file
	);

	void
	DDA_Notify_Access_Port
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pSessionID,			// The session ID
		int		eventID,			// The event ID
		const char	*pUserName,			// The User name
		const char	*pPortID,			// The port ID
		const char	*pPortName			// The Port name
	);

	void
	DDA_Notify_Port_Change
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pPortID,			// The session ID
		const char	*pDeviceName,			// The device name
		const char	*pPortName,				// The Port name
		const char	*pStatus				// The Port Status
	);

	void
	DDA_Notify_Path_Change
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pPathID				// The Path ID
	);

    int
    DDA_FindDownloadPath
    (
        CRDM    *pRDM                   // Ptr to RDM
    );

    char *
    DDA_ConvertVerInfo
    (
        const char * dottedVer,   //The dotted format version information
        char * charCodeVer // Out value giving you the character code version
    );

    int
    DDA_AddVersionInfo
    (
        CRDM    *pRDM,                  // Ptr to RDM
        const char    *pDeviceID,             // Ptr to Device ID
        const char    *pComponent,            // Which component, e.g. CLIPR, UMT, etc
        const char    *pVersionType,          // Type of version, e.g. SW, FW, HW, FPGA, etc
        const char    *pVersionInfo,          // String representing the version
        int     componentIdx            // Component index attribute, -1 => Will not add
    );

   	int
	DDA_UpdateResourceStatus
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// ID of the Resource
		int		status					// Status (0,1,2)
	);

    int
    DDA_ReleaseResources
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// ID of the path
		int		status					// Port status (0,1,2)
	);

    void
    DDA_NotifyWithNameChanged
    (
        CRDM    *pRDM,                  // Ptr to RDM
        const char    *pElement,              // Root Element name (<Device> <User> <Group>)
        const char    *pName,                 // Name of the device, user or group
        const char    *pID,                   // The ID to send to
        int     eventID,                // The event ID
        const char    *pAdminUser             // Admin user who changed the pElement
    );

	void
	DDA_Notify_UserChanged
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// The ID to send to
		int		eventID,				// The event ID
		const char	*pName,					// Name of the user
		const char	*pAdminName				// Admin user who changed the user
	);

	void
	DDA_Notify_GroupChanged
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// The ID to send to
		int		eventID,				// The event ID
		const char	*pName,					// Name of the group
		const char	*pAdminName				// Admin user who changed the group
	);
	void
	DDA_Notify_CCManagement
	(
		CRDM	*pRDM,					// Ptr to RDM
		int		eventID,				// The event ID
		const char	*pServerName,			// Name of this server
		const char	*pName,					// CC user name
		DWORD	address					// CC ipAddress
	);


	void
	DDA_Notify_System_FactoryReset
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pName,					// Name of the user
		DWORD	address					// IPAddress if reset if performed by remote user
	);

	void
	DDA_Notify_PasswordChanged
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// The ID to send to
		int		eventID,				// The event ID
		const char	*pTargetUser,			// User whose password is changed
		const char	*pUser,					// User who changed the password
		DWORD	address					// IPAddress if reset if performed by remote user
	);

	void
	DDA_Notify_DeviceUpdateStarted
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// The ID to send to
		const char	*fwVersion,				// Firmware version being upgraded
		const char	*pUser,					// User who changed the password
		DWORD	address				// IPAddress if reset if performed by remote user
	);

	void
	DDA_Notify_DeviceUpdateCompleted
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// The ID to send to
		const char	*fwVersion,				// Firmware version being upgraded
		const char	*pUser,					// User who changed the password
		DWORD	address,				// IPAddress if reset if performed by remote user
		DWORD	status	
	);

	void
	DDA_Notify_DeviceConfig_Backup_Restore
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// The ID to send to
		int		eventID,				// The event ID
		const char	*fwVersion,				// Firmware version being upgraded
		const char	*type,					// Type of Config file (Device or User)
		const char	*pUser,					// User who changed the password
		DWORD	address,				// IPAddress if reset if performed by remote user
		DWORD	status
	);

    void
    DDA_Notify_DeviceReset
    (
        CRDM    *pRDM,                  // Ptr to RDM
        const char    *pID,                   // The ID to send to
        int     eventID,                // The event ID
        const char    *pName,                 // Device name
        const char    *pResetMode             // Device reset mode
    );

	void									// <0 = error (port was not found)
	DDA_UpdatePowerSupplyStatus
	(
		CRDM	*pRDM,					// Ptr to RDM
		const char	*pID,					// ID of the power supply node
		const char	*pDeviceName,			// The device name
		const char	*pPortName,				// The power supply node name
		int		status,					// status (0 or 1)
		int		index
	);

//------------------------------------------------------------------------------//
//----------------------------------------
//				Static Data
//----------------------------------------

#endif
