/*--------------------------------------------------------------------------------

	RDM_Definitions.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Defines constents common to all RDM modules, client and server

--------------------------------------------------------------------------------*/

#ifndef _RDM_Definitions_H_
#define	_RDM_Definitions_H_

//----------------------------------------
//				Equates
//----------------------------------------

	// Max field sizes for RDM database elements
	// These size include 1 byte for the null terminator
	// 24 = 23 characters + 1 byte null

#define	RDM_MAX_ID			    24		// Max size of a Unique ID, including null terminator

#define	RDM_MAX_TYPE			16		// Max size of Type attribute
#define	RDM_MAX_MODEL			16		// Max size of Model attribute
#define	RDM_MAX_NAME			16		// Max size of a device/port name
#define RDM_MAX_PORT_NAME		32		// Max size of a port name
#define	RDM_MAX_CLASS			16		// Max size of Class attribute
#define	RDM_MAX_NOTIFICATION	255+32	// Max length of an RDM notification
#define	RDM_MAX_NOTIFICATION_DATA   255+32	// Max data section of the event
#define	RDM_MAX_KEY		        16		// Max length of a key string
#define	RDM_MAX_KEY_BASE64		64		// Max length of a key string in base64
#define	RDM_MAX_TEXT_EVENT		79		// Max length of a text event including the null
#define	RDM_MAX_CLUSTER			64		// Cluster ID length
#define	RDM_MAX_USER_NAME		16		// RAASIP: User Name length
#define RDM_MAX_PASSWORD		16		// RAASIP: User Password length
#define RDM_MAX_GROUP_ID		16      // Maximum size (including the null) of the group id
#define RDM_MAX_GROUP_NAME		16      // Maximum size (including the null) of the group name
#define RDM_MAX_DIALBACK		15		// RAASIP: Dial-back phone number

	// Timeout Periods

#define	RDM_REFERRAL_SESSION_TIMEOUT 3*60000	// Timeout period for referral sessions

	//
	// Error Codes
	// Reserved -0x5000(-20480) to -0x4000(-16384), In total 4096 error codes.
	// 				

enum
{
//
//General (-0x5000 to -0x4F01) (reserved error codes: 256)
//
    RDM_ERROR_BASE                                              = -20480,        //
    RDM_ERROR_SERVICE_NOT_FOUND                                 = -20479,        //Unknown RDM service
    RDM_ERROR_FUNCTION_NOT_FOUND                                = -20478,        //Unknown RDM function
    RDM_ERROR_IO_ERROR                                          = -20477,        //I/O Error
    RDM_ERROR_PERMISSION_DENIED                                 = -20476,        //Permission denied
    RDM_ERROR_BAD_PARAMETER                                     = -20475,        //Bad parameter
    RDM_ERROR_MEMORY_ERROR                                      = -20474,        //Memory error
    RDM_ERROR_INVALID_SESSION                                   = -20473,        //Invalid Session
    RDM_ERROR_NOT_SUPPORTED                                     = -20472,        //Not supported
    RDM_ERROR_FULL                                              = -20471,        //Database is full
    RDM_ERROR_INVALID_DATA                                      = -20470,        //Invalid Data
    RDM_ERROR_FAILED                                            = -20469,        //Failed
    RDM_ERROR_RESOURCE_IN_USE                                   = -20468,        //Resource is in use
    RDM_ERROR_INVALID_RESOURCE                                  = -20467,        //Unknown resource CC)
    RDM_ERROR_DEVICE_IS_IN_USE                                  = -20466,        //Device is in use and you cannot manage device from CC)

//
//Device Settings (-0x4F00 to -0x4701) (reserved error codes: 2048)
//
    //General (reserved error codes: 32)
    RDM_ERROR_DEVSET_ROOT_NOT_FOUND                             = -20224,        //Root node not found
    RDM_ERROR_DEVSET_DATA_NOT_FOUND                             = -20223,        //No data in the request
    RDM_ERROR_DEVSET_GET_DATA                                   = -20222,        //Error retrieving data from the request
    RDM_ERROR_DEVSET_PUT_DATA                                   = -20221,        //Error in writing to database
    RDM_ERROR_DEVSET_NODE_NOT_FOUND                             = -20220,        //Node not found
    RDM_ERROR_DEVSET_NORMALIZE_DATA                             = -20219,        //Normalize XPATH for user data structure failed
    RDM_ERROR_DEVSET_NORMALIZE_DB                               = -20218,        //Normalize XPATH for database structure failed

    //
    //Device Access (reserved error codes: 256)
    //

    //General (reserved error codes: 32)
    RDM_ERROR_DEVICE_ACCESS_INVALID_INTERFACE_ID                = -20192,        //
    RDM_ERROR_DEVICE_ACCESS_INVALID_SECURITY_ID                 = -20191,        //
    RDM_ERROR_DEVICE_ACCESS_INVALID_SECURITY_SECURITY_ID        = -20190,        //
    RDM_ERROR_DEVICE_ACCESS_INVALID_NAME                        = -20189,

    //Ethernet (reserved error codes: 16)
    RDM_ERROR_ETHERNET_INVALID_ENABLE                           = -20160,        //
    RDM_ERROR_ETHERNET_INVALID_LINETYPE                         = -20159,        //
    RDM_ERROR_ETHERNET_INVALID_PHY                              = -20158,        //

    //TCP/IP (reserved error codes: 16)
    RDM_ERROR_TCPIP_INVALID_DHCP                                = -20144,        //
    RDM_ERROR_TCPIP_INVALID_GATEWAY                             = -20143,        //
    RDM_ERROR_TCPIP_INVALID_IPADDRESS                           = -20142,        //
    RDM_ERROR_TCPIP_INVALID_SUBNETMASK                          = -20141,        //
    RDM_ERROR_TCPIP_DUPLICATE_IPADDRESS                         = -20140,        //

    //Failover (reserved error codes: 16)
    RDM_ERROR_FAILOVER_INVALID_ENABLE                           = -20128,        //
    RDM_ERROR_FAILOVER_INVALID_NEXTINTERFACE                    = -20127,        //
    RDM_ERROR_FAILOVER_INVALID_TIMEOUT                          = -20126,        //
    RDM_ERROR_FAILOVER_INVALID_PINGINTERVAL                     = -20125,        //

    //Modem (reserved error codes: 16)
    RDM_ERROR_MODEM_INVALID_DIALBACK                            = -20112,        //
    RDM_ERROR_MODEM_INVALID_ENABLE                              = -20111,        //
    RDM_ERROR_MODEM_INVALID_PHONE                               = -20110,        //

    //PPP (reserved error codes: 16)

    //
    //Security (reserved error codes: 128)
    //
    //General (reserved error codes: 16)
    RDM_ERROR_SECURITY_INVALID_DEVICE_RESET_MODE                = -19937,        //
    RDM_ERROR_SECURITY_INVALID_ENCRYPTIONMODE                   = -19936,        //
    RDM_ERROR_SECURITY_INVALID_REMOTE_ADMIN                     = -19935,        //
    RDM_ERROR_SECURITY_INVALID_CONCURRENT_ACCESS                = -19934,        //
    RDM_ERROR_SECURITY_INVALID_ENABLE_STRONG_PASSWORD           = -19933,        //
    RDM_ERROR_SECURITY_INVALID_PASSWORD_VALIDITY_PERIOD         = -19932,        //
    RDM_ERROR_SECURITY_INVALID_SINGLE_USER_LOGIN                = -19931,        //
    
    //Remote Authentication (reserved error codes: 32)
    RDM_ERROR_REMOTE_AUTH_INVALID_SECURITY_ID                   = -19920,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_ID						= -19919,		 //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_PRIORITY				= -19918,		 //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_ENABLE                 = -19917,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_PROTOCOL               = -19916,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_AUTHENTICATE_TYPE      = -19915,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_SECRET                 = -19914,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_IPADDR                 = -19913,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_IPPORT                 = -19912,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_TIMEOUT                = -19911,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_BASEDN                 = -19910,        //
    RDM_ERROR_REMOTE_AUTH_INVALID_SERVER_BASESEARCH             = -19909,        //

    //Logout Idle User (reserved error codes: 16)
    RDM_ERROR_LOGOUTIDLE_INVALID_ENABLE                         = -19888,        //
    RDM_ERROR_LOGOUTIDLE_INVALID_TIMEOUT                        = -19887,        //

    //ACL (reserved error codes: 16)
    RDM_ERROR_ACL_INVALID_ACTION                                = -19872,        //
    RDM_ERROR_ACL_INVALID_IPADDRESS                             = -19871,        //
    RDM_ERROR_ACL_INVALID_POSITION                              = -19870,        //

    //
    //Management (19808 - )(reserved error codes: 256)
    //

	//General (reserved error codes: 16)

    //SNTP (reserved error codes: 32)
    RDM_ERROR_SNTP_INVALID_ENABLE                               = -19792,        //
    RDM_ERROR_SNTP_INVALID_ADJUSTDST                            = -19791,        //
    RDM_ERROR_SNTP_INVALID_TIMEZONE                             = -19790,        //
    RDM_ERROR_SNTP_INVALID_SERVER_ID							= -19789,		 //
    RDM_ERROR_SNTP_INVALID_SERVER_PRIORITY						= -19788,		 //
    RDM_ERROR_SNTP_INVALID_SERVER_ENABLE                        = -19787,        //
    RDM_ERROR_SNTP_INVALID_SERVER_IPADDR                        = -19786,        //
    RDM_ERROR_SNTP_INVALID_SERVER_IPPORT                        = -19785,        //
    RDM_ERROR_SNTP_INVALID_SERVER_IPTIMEOUT                     = -19784,        //

    //SNMP (reserved error codes: 16)
    RDM_ERROR_SNMP_INVALID_ENABLE                               = -19760,        //
    RDM_ERROR_SNMP_INVALID_NAME	                                = -19759,        //
    RDM_ERROR_SNMP_INVALID_CONTACT								= -19758,        //
    RDM_ERROR_SNMP_INVALID_LOCATION	                            = -19757,        //
    RDM_ERROR_SNMP_INVALID_COMMUNITY_NAME                       = -19756,        //
    RDM_ERROR_SNMP_INVALID_COMMUNITY_TYPE						= -19755,        //
    RDM_ERROR_SNMP_INVALID_SERVER_ID	                        = -19754,        //
    RDM_ERROR_SNMP_INVALID_SERVER_ENABLE	                    = -19753,        //
    RDM_ERROR_SNMP_INVALID_SERVER_PROTOCOL                      = -19752,
    RDM_ERROR_SNMP_INVALID_SERVER_COMMUNITY_NAME                = -19751,        //
    RDM_ERROR_SNMP_INVALID_IPADDRESS	                        = -19750,        //
    RDM_ERROR_SNMP_INVALID_IPPort	                            = -19749,        //
    RDM_ERROR_SNMP_INVALID_NUM_SERVERS							= -19748,		 //
    RDM_ERROR_SNMP_INVALID_NUM_COMMUNITY_STRINGS				= -19747,		 //

    //HTTP (reserved error codes: 16)
    RDM_ERROR_HTTP_INVALID_ENABLE                               = -19744,        //

    //Accouting (reserved error codes: 32)
    RDM_ERROR_ACCOUTING_INVALID_SECURITY_ID                     = -19728,        //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_ID						= -19727,		 //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_PRIORITY					= -19726,		 //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_ENABLE                   = -19725,        //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_IPADDR                   = -19724,        //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_IPPORT                   = -19723,        //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_PROTOCOL                 = -19722,        //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_SECRET                   = -19721,        //
    RDM_ERROR_ACCOUTING_INVALID_SERVER_TIMEOUT                  = -19720,        //

    //Logging (reserved error codes: 32)
    RDM_ERROR_LOGGING_INVALID_SERVER_ID							= -19696,		 //
    RDM_ERROR_LOGGING_INVALID_SERVER_ENABLE                     = -19695,        //
    RDM_ERROR_LOGGING_INVALID_SERVER_PROTOCOL                   = -19694,        //
    RDM_ERROR_LOGGING_INVALID_SERVER_IPADDR                     = -19693,        //
    RDM_ERROR_LOGGING_INVALID_SERVER_IPPORT                     = -19692,        //
    RDM_ERROR_LOGGING_INVALID_SERVER_CATEGORY                   = -19691,        //
    RDM_ERROR_LOGGING_INVALID_SERVER_PRIORITYTHRESHOLD          = -19690,        //

    //
    //Performance (reserved error codes: 64)
    //
    RDM_ERROR_PERFORMANCE_INVALID_SECURITY_ID                   = -19552,        //
    RDM_ERROR_PERFORMANCE_INVALID_MAXIMUMBANDWIDTHUSAGE         = -19551,        //
    RDM_ERROR_PERFORMANCE_INVALID_MAXIMUMBANDWIDTHPERSESSION    = -19550,        //
    RDM_ERROR_PERFORMANCE_INVALID_PAUSEVIDEOIDLE_ENABLE         = -19549,        //
    RDM_ERROR_PERFORMANCE_INVALID_PAUSEVIDEOIDLE_TIMEOUT        = -19548,        //

    //
    //Application (reserved error codes: 64)
    //
    RDM_ERROR_APPLICATION_INVALID_ID                            = -19488,        //
    RDM_ERROR_APPLICATION_INVALID_KVMPATHCONFIG                 = -19487,        //
    RDM_ERROR_APPLICATION_INVALID_IPPORT                        = -19486,        //
    RDM_ERROR_APPLICATION_INVALID_BLANKUSERPORT                 = -19485,        //
    RDM_ERROR_APPLICATION_INVALID_LOGOUTKVM                     = -19484,        //

	//
	//PowerSupply (reserved error codes: 16)
	//
    RDM_ERROR_POWERSUPPLY_INVALID_ENABLE	                    = -19424,        //

//
//Userspace (-0x4700 to -0x4501) (reserved error codes: 512)
//
    //General (reserved error codes: 32)
    RDM_ERROR_US_DATA_NOT_FOUND                                 = -18176,        //No data in the request
    RDM_ERROR_US_GET_DATA                                       = -18175,        //Error in retrieving data from the request
    RDM_ERROR_US_PUT_DATA                                       = -18174,        //Error in writing to database
    RDM_ERROR_US_NODE_NOT_FOUND                                 = -18173,        //Database Node not found
    RDM_ERROR_US_NORMALIZE_DATA                                 = -18172,        //Normalize XPATH for user data structure failed
    RDM_ERROR_US_NORMALIZE_DB                                   = -18171,        //Normalize XPATH for database structure failed
    RDM_ERROR_US_GET_DB                                         = -18170,        //Error retrieving data from database

    //Group (reserved error codes: 64)
    RDM_ERROR_GROUP_INVALID_ID                                  = -18144,        //
    RDM_ERROR_GROUP_INVALID_NAME                                = -18143,        //
    RDM_ERROR_GROUP_INVALID_INDIVIDUAL                          = -18142,        //
    RDM_ERROR_GROUP_INVALID_ACTIVE                              = -18141,        //
    RDM_ERROR_GROUP_INVALID_CONCURRENT_ACCESS                   = -18140,        //
    RDM_ERROR_GROUP_INVALID_ACL                                 = -18139,        //
    RDM_ERROR_GROUP_INVALID_PERMISSION                          = -18138,        //

    //User (reserved error codes: 64)
    RDM_ERROR_USER_INVALID_ID                                   = -18080,        //
    RDM_ERROR_USER_INVALID_ACTIVE                               = -18079,        //
    RDM_ERROR_USER_INVALID_NAME                                 = -18078,        //
    RDM_ERROR_USER_INVALID_PASSWORD                             = -18077,        //
    RDM_ERROR_USER_INVALID_PREVPASSWORD                         = -18076,        //
    RDM_ERROR_USER_INVALID_GROUP_ID                             = -18075,        //
    RDM_ERROR_USER_INVALID_PHONE                                = -18074,        //

//
//Power (-0x4500 to -0x4301) (reserved error codes: 512)
//
    //Outlet (reserved error codes: 64)
    RDM_ERROR_INVALID_OUTLET_RENAME                             = -17664,        //Invalid renaming when the outlet is associated

//
//Paragon (-0x4300 to -0x4101) (reserved error codes: 512)
//
    //General (reserved error codes: 64)
    RDM_ERROR_PARAGON_ADDUMT_FIRST_FAILED                       = -17152,       //Adding First UMT failed
    RDM_ERROR_PARAGON_ADDUMT_FAILED                             = -17151        //Adding non-first UMT failed 
};

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------


#endif // _RDM_Definitions_H_



