/*--------------------------------------------------------------------------------

	RDM_Power.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Service.cpp and the CRDM_Power class

--------------------------------------------------------------------------------*/

#ifndef _RDM_Power_H_
#define	_RDM_Power_H_

#include "pp/Session.h"
#include "pp/RDM_Service.h"
#include "pp/RDM_Subscription.h"
#include "pp/OS_Port.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Power : public CRDM_Service
{
public:

	CRDM_Power
	(
		class CRDM	*	pRDM			// Ptr to the RDM object
	);

	virtual ~CRDM_Power();

	virtual
	int									// 0 or error code if request failed
	Command
	(
		CSession	*	pUserSession,	// The user session or NULL for super user
		CSXDB_Node	*	pRootNode,		// Ptr to the root node of our functions
		CSIO		*	pResponse		// The response -
										// Contains the return value on exit
	);

	virtual
	int								// I/O error on output
	On
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	virtual
	int								// I/O error on output
	Off
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	virtual
	int								// I/O error on output
	Cycle
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	virtual
	int								// I/O error on output
	Associate
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	virtual
	int								// I/O error on output
	PowerStripStatus
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	inline
	void
	SetRDM
	(
		class CRDM	*	pNewRDM		// Ptr to the new RDM object
	)
	{
		pRDM = pNewRDM;
	};

protected:

	int								// I/O error on output
	SetPowerState
	(
		CSession	*pUserSession,	// User session
		const char	*pID,			// ID of the port to control
		CSIO		*pResponse,		// SIO Response
		int			state			// power state
	);

	virtual
	int								// I/O error on output
	DEP_SetPowerStateOfOutlet
	(
		const char		*	pID,
		int				state
	);

	virtual
	char *									// I/O error on output
	DEP_GetPowerStripStatus
	(
		const char		*	pID
	);

	// --------------------------------
	// Data
	// --------------------------------

	class CRDM	*	pRDM;				// Ptr to the RDM object
};

#endif // _RDM_Power_H_

