/*--------------------------------------------------------------------------------

	RDM_Secure_SXDB.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Secure_SXDB.cpp and the CRDM_Secure_SXDB class

--------------------------------------------------------------------------------*/

#ifndef _RDM_Secure_SXDB_H_
#define	_RDM_Secure_SXDB_H_

#include "pp/SXML_Errors.h"
#include "pp/SXML.h"
#include "pp/SXDB.h"
#include "pp/OS_Port.h"
#include "pp/Session.h"

//----------------------------------------
//				Equates
//----------------------------------------

#define			MAX_SECURITY_CONTEXT_DEPTH	32

//----------------------------------------
//				Data Types
//----------------------------------------

	// Security Context Structure

typedef struct
{
	CSXDB_Node	*pTop;					// Top node we have security info for
	CSession	*pUser;					// The user node
	int			count;					// # of levels down we have info for
	int			info[MAX_SECURITY_CONTEXT_DEPTH];	// Security info for each level
} SXDB_Security_Context;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Secure_SXDB : public CSXDB
{
public:
	CRDM_Secure_SXDB();
	~CRDM_Secure_SXDB();

	void
	BeginAccess
	(
		int	write						// 0 = read only, !0 = read/write access
	);

	void
	EndAccess
	(
	);

	int									// !0 if access is allowed
										// 0 = Not allowed
										// -1 = unknown for this node
	CheckAccess
	(
		CSXDB_Node	*pNode,				// The node to authorize
		void		*pUser,				// User account
		int			accessType,			// SXDB_ACCESS_xxx
		int			oneLevel = 0		// !0 = only check pNode, not it's ansestors
	);

	// Utility Functions

	void
	GetSecurityIDForNode
	(
		CSXDB_Node	*pNode,				// The node to search
		const char	**pSecurityID,		// Returns the securityID, or NULL if none found
		const char	**pID				// Returns the id attribute found at the same
										// level as the securityID or NULL if none found
	);

	void
	GetSecurityID
	(
		CSXDB_Node	*pNode,				// The node to search
		const char	**pSecurityID,		// Returns the securityID, or NULL if none found
		const char	**pID				// Returns the id attribute found at the same
										// level as the securityID or NULL if none found
	);

	// --------------------------------
	// Public Data
	// --------------------------------

public:


	// --------------------------------
	// Private Data
	// --------------------------------

private:

	OS_CRITICAL_SECTION		cs;			// cs for accessing the database

};

#endif // _RDM_Secure_SXDB_H_


