/*--------------------------------------------------------------------------------

	RDM_Service.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Service.cpp and the CRDM_Service class

--------------------------------------------------------------------------------*/

#ifndef _RDM_Service_H_
#define	_RDM_Service_H_

#include "pp/Session.h"
#include "pp/SXDB.h"
#include "pp/SXML.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Service
{
public:

	CRDM_Service
	(
	);

	virtual ~CRDM_Service();

	inline
	const char *								// Ptr to the service name
	GetName() {	return pName; }


	inline
	int									// the hash code
	GetHashCode() { return hashCode; }

	virtual
	int									// 0 or error code if request failed
	Command
	(
		CSession	*	pUserSession,	// The user session or NULL for super user
		CSXDB_Node	*	pRootNode,		// Ptr to the root node of our functions
		CSIO		*	pResponse		// The response -
										// Contains the return value on exit
	);

	CSXDB_Node *						// Ptr to the service name
	GetFirstFunction
	(
		CSXDB_Node	*pRootNode			// Ptr to the Service node
	);

	CSXDB_Node *						// Ptr to the service name
	GetNextFunction
	(
		CSXDB_Node	*pNode				// Ptr to the last function node
	);

	int									// io result
	PrintError
	(
		CSIO	*pOut,
		int		error
	);

	// --------------------------------
	// Data
	// --------------------------------

public:

	class CRDM_Service *	pNext;		// Ptr to the next server in the linked list

protected:

	int				hashCode;			// hash of the service name for fast compare
	const char		*	pName;				// Name of this service

	friend class CRDMP;
};

#endif // _RDM_Service_H_


