/*---------------------------------------------------------------------------

	RDM_System.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_System.cpp and the CRDM_System class

---------------------------------------------------------------------------*/

#ifndef _RDM_System_H_
#define	_RDM_System_H_

#include "pp/Session.h"
#include "pp/RDM_Service.h"
#include "pp/RDM_Subscription.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_System : public CRDM_Service
{
public:

	CRDM_System
	(
		class CRDM	*	pRDM			// Ptr to the RDM object
	);

	~CRDM_System();

	virtual
	int									// 0 or error code if request failed
	Command
	(
		CSession	*	pUserSession,	// User session
		CSXDB_Node	*	pRootNode,		// Ptr to root node of our functions
		CSIO		*	pResponse		// The response -
										// Contains the return value on exit
	);

	int								// I/O error on output
	GetVersion	
	(
	);

	int								// I/O error on output
	Restart
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Shutdown
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	StartManagement
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	StopManagement
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	GetTime
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	SetTime
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	IPR_StopAllVideo
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	// --------------------------------
	// Platform dependent methods
	// --------------------------------

	virtual
	int								// RDM Error
	DEP_ShutDown
	(
	);

	virtual
	int								// RDM Error
	DEP_Restart
	(
	);

	virtual
	CSXDB_Node	*					// Ptr to DeviceSettings
	DEP_GetCCDeviceSettings
	(
	);

	virtual
	void
	DEP_CommitCCDeviceSettings
	(
	);

	virtual
	int									// RDM_ERROR
	DEP_CloseAllVideoStreams
	(
	);

    virtual
	BOOL
	DEP_InitializeManagement
	(
	);

	virtual
	BOOL
	DEP_AreWeManaged
	(
	);

	virtual
    void
    DEP_StopManagement
    (
    );

	virtual
    void	
	DEP_SetVersion
	(
		int version
	);

	// --------------------------------
	// Data
	// --------------------------------

protected:

	class CRDM	*	pRDM;				// Ptr to the RDM object

	int version;						// RDM_System Version number
};



#endif // _RDM_System_H_


