/**	
 *  @file	ppRFPPack.h
 *  @brief	CRFPPack definition
 * 
 *  eirc firmware specific version of RFPPack
 *	
 */

#ifndef _ppRFPPack_h_
#define _ppRFPPack_h_
#include "pp/RFPPack.h"

namespace pp
{

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	Class
 *--------------------------------------*/

class ppRFPPack : public CRFPPack
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief	Constructor for a CRFP object
	 *
     *  The CRFP object processes 1 RFP file. Processing includes
     *  parsing the header, decrypting files, checking signatures,
     *  forking a processes to run shell scripts and copying files
     *  to destination locations.
	 *
     *  @param	pRSAFile	Ptr to the RSA File Name (NULL = use
     *                      default)
     *  @param	pRC4File	Ptr to the RC4 File Name (NULL = use
     *                      default)
	 *
	 */

	ppRFPPack( );
	virtual ~ppRFPPack();

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief	Resolves A metafile into a realfile for metafiles
     *         where <SourceFile> is not specified in the RFP
     *         header.
     * 
     *  This function can be overridden to resolve metafiles.
     *  Te default implmentation returns an error.
     * 
     *  @param  pMetaFileName   Ptr to the Metafile to resolve
     *  @param  pOutRealFileName Buffer to return the real file name
     *  @return				Returns RFP_OK or RFP_ERROR_ if file
     *                      cannot be resolved
	 *
	 */

	virtual int ResolveMetaFile( char *pMetaFileName, char *pOutRealFileName );

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief  Cleans up after a Metafile.
     * 
     *  This function can be overridden to do any needed cleanup of
     *  resolved metafiles.
     *  The default implementation does nothing.
     * 
     *  @param  pMetaFileName   Ptr to the Metafile to resolve
     *  @param  pResolvedFileName Buffer containing the real file
     *                            name
     *  @return				Returns RFP_OK or RFP_ERROR_ if file
     *                      cannot be resolved
	 *
	 */

	virtual int ReleaseMetaFile( char *pMetaFileName, char *pResolvedFileName );

	/*  --------------------------------------------------------------------*/
	/*  --------------------------------------------------------------------*/

private:

};

} // namespace

#endif	// _ppRFPPack_h_


